(ns antistock.db.util
  (:refer-clojure :exclude [distinct group-by update])
  (:require [clojure.string :refer [blank?]]
            [datumbazo.core :refer :all]))

(defn fulltext
  "Add a where condition to a select query."
  [query & columns]
  (when-not (blank? query)
    (where `(or (~(keyword "@@")
                 (to_tsvector (array_to_string [~@columns], " "))
                 (plainto_tsquery ~query))
                ~@(map #(list 'like %1 (str "%" query "%")) columns))
           :and)))
