-- Deploy create-users-table

BEGIN;

CREATE TABLE users (
  id serial PRIMARY KEY,
  name citext UNIQUE NOT NULL,
  email citext UNIQUE NOT NULL,
  crypted_password text NOT NULL,
  created_at timestamp with time zone NOT NULL DEFAULT now(),
  updated_at timestamp with time zone NOT NULL DEFAULT now()
);

CREATE TRIGGER users_created_at_trigger
  BEFORE INSERT ON users FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER users_updated_at_trigger
  BEFORE UPDATE ON users FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
