(ns antistock.db.sectors
  (:refer-clojure :exclude [distinct group-by update])
  (:require [clojure.java.jdbc :as jdbc]
            [datumbazo.core :refer :all]))

(deftable sectors
  "The sectors database table."
  (column :id :serial :primary-key? true)
  (column :name :citext :not-null? true :unique? true)
  (column :created-at :timestamp-with-time-zone :not-null? true :default "now()")
  (column :updated-at :timestamp-with-time-zone :not-null? true :default "now()"))
