-- Deploy create-quotes-table
-- requires: create-citext-extension

BEGIN;

CREATE TABLE quotes (
  id serial PRIMARY KEY,
  exchange_id INTEGER REFERENCES exchanges(id) ON DELETE SET NULL,
  company_id INTEGER REFERENCES companies(id) ON DELETE SET NULL,
  symbol citext UNIQUE NOT NULL,
  created_at timestamp with time zone NOT NULL DEFAULT now(),
  updated_at timestamp with time zone NOT NULL DEFAULT now()
);

CREATE INDEX quotes_company_id_idx ON quotes (company_id);
CREATE INDEX quotes_exchange_id_idx ON quotes (exchange_id);
CREATE INDEX quotes_symbol_idx ON quotes (symbol);

CREATE TRIGGER quotes_created_at_trigger
  BEFORE INSERT ON quotes FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER quotes_updated_at_trigger
  BEFORE UPDATE ON quotes FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
