(ns antistock.db.links
  (:refer-clojure :exclude [distinct group-by update])
  (:require [clojure.java.jdbc :as jdbc]
            [datumbazo.core :refer :all]))

(deftable links
  "The web links database table."
  (column :id :serial :primary-key? true)
  (column :url :citext :not-null? true :unique? true)
  (column :body :text)
  (column :content-type :citext)
  (column :created-at :timestamp-with-time-zone :not-null? true :default "now()")
  (column :updated-at :timestamp-with-time-zone :not-null? true :default "now()")
  (primary-key :url))

(deftable links-quotes
  "The join table between links and quotes."
  (column :link-id :integer :not-null? true :references :links/id)
  (column :quote-id :integer :not-null? true :references :quotes/id))
