-- Deploy add-wikipedia-page-id-to-companies

BEGIN;

ALTER TABLE companies ADD COLUMN wikipedia_page_id INTEGER REFERENCES wikipedia.pages(id);

CREATE UNIQUE INDEX companies_wikipedia_page_id_idx ON companies (wikipedia_page_id);

UPDATE companies
   SET wikipedia_page_id = pages.id
  FROM (SELECT id, url FROM wikipedia.pages) AS pages
 WHERE lower(companies.wikipedia_url) = lower(pages.url);

ALTER TABLE companies DROP COLUMN wikipedia_url;

COMMIT;
