-- Deploy create-continents-table

BEGIN;

CREATE TABLE continents (
  id SERIAL PRIMARY KEY,
  name CITEXT UNIQUE NOT NULL,
  code CITEXT UNIQUE NOT NULL,
  geom GEOMETRY(MULTIPOLYGON, 4326),
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX continents_name_fulltext_index ON continents USING gin(to_tsvector('english', name));
CREATE INDEX continents_geom_index ON continents USING gist(geom);

CREATE TRIGGER continents_created_at_trigger
  BEFORE INSERT ON continents FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER continents_updated_at_trigger
  BEFORE UPDATE ON continents FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
