-- Deploy create-wikipedia-pages-table

BEGIN;

CREATE TABLE wikipedia.pages (
  id SERIAL PRIMARY KEY,
  url TEXT UNIQUE NOT NULL,
  title TEXT,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX wikipedia_pages_url_index ON wikipedia.pages (url);
CREATE INDEX wikipedia_pages_title_fulltext_index ON wikipedia.pages USING gin(to_tsvector('english', title));

CREATE TRIGGER wikipedia_pages_created_at_trigger
  BEFORE INSERT ON wikipedia.pages FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER wikipedia_pages_updated_at_trigger
  BEFORE UPDATE ON wikipedia.pages FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
