(ns antistock.db.system
  (:require [clojure.string :as str]
            [com.stuartsierra.component :as component]
            [datumbazo.core :as d]
            [sqlingvo.db :refer [postgresql]]
            [no.en.core :refer [format-url]]))

(defn- hyphenate [s]
  (keyword (str/replace (name s) "_" "-")))

(defn- underscore [s]
  (str/replace (name s) "-" "_"))

(defn new-db [config]
  (assoc (d/new-db config)
         :backend 'jdbc.core))

(defn jdbc-url
  "Returns the JDBC url for `db`."
  [db & [opts]]
  (format-url
   {:scheme (str "jdbc:" (name (:scheme db)))
    :server-name (:server-name db)
    :server-port (:server-port db)
    :uri (str "/" (:name db))
    :query-params
    (assoc opts
           :user (:user db)
           :password (:password db))}))

(defmacro with-component
  "Create a new component with `new-form`, bind the started component
  to `component-sym`, evaluate `body` and stop the component again."
  [[component-sym new-form] & body]
  `(let [component# (component/start ~new-form)
         ~component-sym component#]
     (try ~@body
          (finally (component/stop component#)))))

(defmacro with-db
  "Eval `body` within the context of a database."
  [[db-sym config & [opts]] & body]
  `(d/with-db [~db-sym (new-db ~config) ~opts]
     ~@body))
