-- Deploy daily-return-predictions

BEGIN;

CREATE TABLE predictions."daily-return" (
  id serial PRIMARY KEY,
  "quote-id" integer NOT NULL REFERENCES quotes(id) ON DELETE CASCADE,
  date date NOT NULL,
  prediction DOUBLE PRECISION NOT NULL,
  "created-at" timestamp with time zone NOT NULL DEFAULT now(),
  "updated-at" timestamp with time zone NOT NULL DEFAULT now()
);

CREATE UNIQUE INDEX "predictions-daily-return-quote-id-date-idx" ON predictions."daily-return" ("quote-id", date);

CREATE TRIGGER "predictions-daily-return-created-at-trigger"
  BEFORE INSERT ON predictions."daily-return" FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER "predictions-daily-return-updated-at-trigger"
  BEFORE UPDATE ON predictions."daily-return" FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
