-- Deploy create-companies-table

BEGIN;

CREATE TABLE companies (
  id serial PRIMARY KEY,
  country_id INTEGER REFERENCES countries(id) ON DELETE CASCADE,
  sector_id INTEGER REFERENCES sectors(id) ON DELETE CASCADE,
  industry_id INTEGER REFERENCES industries(id) ON DELETE CASCADE,
  name citext UNIQUE NOT NULL,
  wikipedia_url TEXT,
  created_at timestamp with time zone NOT NULL DEFAULT now(),
  updated_at timestamp with time zone NOT NULL DEFAULT now()
);

CREATE INDEX companies_industry_id_idx ON companies (industry_id);
CREATE INDEX companies_name_idx ON companies USING GIN(to_tsvector('english', name));
CREATE INDEX companies_sector_id_idx ON companies (sector_id);

CREATE TRIGGER companies_created_at_trigger
  BEFORE INSERT ON companies FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER companies_updated_at_trigger
  BEFORE UPDATE ON companies FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
