(ns antistock.db.continents
  (:refer-clojure :exclude [distinct group-by update])
  (:require [datumbazo.core :refer :all]))

(deftable continents
  "The continents database table."
  (column :id :serial :primary-key? true)
  (column :code :citext :not-null? true :unique? true)
  (column :name :citext :not-null? true :unique? true)
  (column :geom :geometry :hidden? true)
  (column :created-at :timestamp-with-time-zone :not-null? true :default "now()")
  (column :updated-at :timestamp-with-time-zone :not-null? true :default "now()"))

(defn asia
  "Find Asia."
  [db] (continent-by-code db "as"))

(defn europe
  "Find Europe."
  [db] (continent-by-code db "eu"))

(defn north-america
  "Find the North America."
  [db] (continent-by-code db "na"))
