-- Deploy create-twitter-access-tokens

BEGIN;

CREATE TABLE twitter."access-tokens" (
  "id" serial PRIMARY KEY,
  "application-id" bigint NOT NULL REFERENCES twitter.applications(id) ON DELETE CASCADE,
  "user-id" bigint NOT NULL REFERENCES twitter.users(id) ON DELETE CASCADE,
  "access-token" text NOT NULL,
  "access-token-secret" text NOT NULL,
  "created-at" timestamp with time zone NOT NULL DEFAULT now(),
  "updated-at" timestamp with time zone NOT NULL DEFAULT now()
);

CREATE UNIQUE INDEX "twitter-access-tokens-application-id-user-id-idx" ON twitter."access-tokens"("application-id", "user-id");

CREATE TRIGGER "twitter-access-tokens-created-at-trigger"
  BEFORE INSERT ON twitter."access-tokens" FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER "twitter-access-tokens-updated-at-trigger"
  BEFORE UPDATE ON twitter."access-tokens" FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
