-- Deploy create-wikipedia-projects-table

BEGIN;

CREATE TABLE wikipedia.projects (
  id SERIAL PRIMARY KEY,
  name CITEXT UNIQUE NOT NULL,
  url TEXT UNIQUE NOT NULL,
  abbrev CITEXT UNIQUE,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX wikipedia_projects_name_fulltext_index ON wikipedia.projects USING gin(to_tsvector('english', name));

CREATE TRIGGER wikipedia_projects_created_at_trigger
  BEFORE INSERT ON wikipedia.projects FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER wikipedia_projects_updated_at_trigger
  BEFORE UPDATE ON wikipedia.projects FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
