-- Deploy underscore-to-dash

BEGIN;

-- companies
ALTER TABLE companies RENAME COLUMN country_id TO "country-id";
ALTER TABLE companies RENAME COLUMN sector_id TO "sector-id";
ALTER TABLE companies RENAME COLUMN industry_id TO "industry-id";
ALTER TABLE companies RENAME COLUMN wikipedia_page_id TO "wikipedia-page-id";
ALTER TABLE companies RENAME COLUMN created_at TO "created-at";
ALTER TABLE companies RENAME COLUMN updated_at TO "updated-at";

-- continents
ALTER TABLE continents RENAME COLUMN created_at TO "created-at";
ALTER TABLE continents RENAME COLUMN updated_at TO "updated-at";

-- countries
ALTER TABLE countries RENAME COLUMN continent_id TO "continent-id";
ALTER TABLE countries RENAME COLUMN iso_3166_1_alpha_2 TO "iso-3166-1-alpha-2";
ALTER TABLE countries RENAME COLUMN iso_3166_1_alpha_3 TO "iso-3166-1-alpha-3";
ALTER TABLE countries RENAME COLUMN iso_3166_1_numeric TO "iso-3166-1-numeric";
ALTER TABLE countries RENAME COLUMN fips_code TO "fips-code";
ALTER TABLE countries RENAME COLUMN geonames_id TO "geonames-id";
ALTER TABLE countries RENAME COLUMN phone_prefix TO "phone-prefix";
ALTER TABLE countries RENAME COLUMN created_at TO "created-at";
ALTER TABLE countries RENAME COLUMN updated_at TO "updated-at";

-- exchanges
ALTER TABLE exchanges RENAME COLUMN country_id TO "country-id";
ALTER TABLE exchanges RENAME COLUMN created_at TO "created-at";
ALTER TABLE exchanges RENAME COLUMN updated_at TO "updated-at";

-- industries
ALTER TABLE industries RENAME COLUMN created_at TO "created-at";
ALTER TABLE industries RENAME COLUMN updated_at TO "updated-at";

-- languages
ALTER TABLE languages RENAME COLUMN iso_639_1 TO "iso-639-1";
ALTER TABLE languages RENAME COLUMN iso_639_2 TO "iso-639-2";
ALTER TABLE languages RENAME COLUMN created_at TO "created-at";
ALTER TABLE languages RENAME COLUMN updated_at TO "updated-at";

-- links
ALTER TABLE links RENAME COLUMN content_type TO "content-type";
ALTER TABLE links RENAME COLUMN created_at TO "created-at";
ALTER TABLE links RENAME COLUMN updated_at TO "updated-at";

-- links_quotes
ALTER TABLE links_quotes RENAME COLUMN link_id TO "link-id";
ALTER TABLE links_quotes RENAME COLUMN quote_id TO "quote-id";
ALTER TABLE links_quotes RENAME TO "links-quotes";

-- prices
ALTER TABLE prices RENAME COLUMN quote_id TO "quote-id";
ALTER TABLE prices RENAME COLUMN adj_close TO "adj-close";
ALTER TABLE prices RENAME COLUMN daily_return TO "daily-return";
ALTER TABLE prices RENAME COLUMN created_at TO "created-at";
ALTER TABLE prices RENAME COLUMN updated_at TO "updated-at";

-- quotes
ALTER TABLE quotes RENAME COLUMN exchange_id TO "exchange-id";
ALTER TABLE quotes RENAME COLUMN company_id TO "company-id";
ALTER TABLE quotes RENAME COLUMN created_at TO "created-at";
ALTER TABLE quotes RENAME COLUMN updated_at TO "updated-at";

-- sectors
ALTER TABLE sectors RENAME COLUMN created_at TO "created-at";
ALTER TABLE sectors RENAME COLUMN updated_at TO "updated-at";

-- users
ALTER TABLE users RENAME COLUMN crypted_password TO "crypted-password";
ALTER TABLE users RENAME COLUMN created_at TO "created-at";
ALTER TABLE users RENAME COLUMN updated_at TO "updated-at";

-- twitter.hash_tags
ALTER TABLE twitter.hash_tags RENAME COLUMN created_at TO "created-at";
ALTER TABLE twitter.hash_tags RENAME COLUMN updated_at TO "updated-at";
ALTER TABLE twitter.hash_tags RENAME TO "hash-tags";

-- twitter.hash_tags_tweets
ALTER TABLE twitter.hash_tags_tweets RENAME COLUMN hash_tag_id TO "hash-tag-id";
ALTER TABLE twitter.hash_tags_tweets RENAME COLUMN tweet_id TO "tweet-id";
ALTER TABLE twitter.hash_tags_tweets RENAME TO "hash-tags-tweets";

-- twitter.links_tweets
ALTER TABLE twitter.links_tweets RENAME COLUMN link_id TO "link-id";
ALTER TABLE twitter.links_tweets RENAME COLUMN tweet_id TO "tweet-id";
ALTER TABLE twitter.links_tweets RENAME TO "links-tweets";

-- twitter.tweets
ALTER TABLE twitter.tweets RENAME COLUMN user_id TO "user-id";
ALTER TABLE twitter.tweets RENAME COLUMN in_reply_to_status_id TO "in-reply-to-status-id";
ALTER TABLE twitter.tweets RENAME COLUMN in_reply_to_user_id TO "in-reply-to-user-id";
ALTER TABLE twitter.tweets RENAME COLUMN in_reply_to_screen_name TO "in-reply-to-screen-name";
ALTER TABLE twitter.tweets RENAME COLUMN retweet_count TO "retweet-count";
ALTER TABLE twitter.tweets RENAME COLUMN created_at TO "created-at";
ALTER TABLE twitter.tweets RENAME COLUMN updated_at TO "updated-at";

-- twitter.tweets_quotes
ALTER TABLE twitter.tweets_quotes RENAME COLUMN tweet_id TO "tweet-id";
ALTER TABLE twitter.tweets_quotes RENAME COLUMN quote_id TO "quote-id";
ALTER TABLE twitter.tweets_quotes RENAME TO "tweets-quotes";

-- twitter.tweets_users
ALTER TABLE twitter.tweets_users RENAME COLUMN tweet_id TO "tweet-id";
ALTER TABLE twitter.tweets_users RENAME COLUMN user_id TO "user-id";
ALTER TABLE twitter.tweets_users RENAME TO "tweets-users";

-- twitter.users
ALTER TABLE twitter.users RENAME COLUMN screen_name TO "screen-name";
ALTER TABLE twitter.users RENAME COLUMN followers_count TO "followers-count";
ALTER TABLE twitter.users RENAME COLUMN friends_count TO "friends-count";
ALTER TABLE twitter.users RENAME COLUMN listed_count TO "listed-count";
ALTER TABLE twitter.users RENAME COLUMN retweet_count TO "retweet-count";
ALTER TABLE twitter.users RENAME COLUMN statuses_count TO "statuses-count";
ALTER TABLE twitter.users RENAME COLUMN possibly_sensitive TO "possibly-sensitive";
ALTER TABLE twitter.users RENAME COLUMN time_zone TO "time-zone";
ALTER TABLE twitter.users RENAME COLUMN utc_offset TO "utc-offset";
ALTER TABLE twitter.users RENAME COLUMN profile_image_url TO "profile-image-url";
ALTER TABLE twitter.users RENAME COLUMN default_profile_image TO "default-profile-image";
ALTER TABLE twitter.users RENAME COLUMN created_at TO "created-at";
ALTER TABLE twitter.users RENAME COLUMN updated_at TO "updated-at";

-- wikipedia.page_edits
ALTER TABLE wikipedia.page_edits RENAME COLUMN page_id TO "page-id";
ALTER TABLE wikipedia.page_edits RENAME COLUMN edited_at TO "edited-at";
ALTER TABLE wikipedia.page_edits RENAME COLUMN updated_at TO "updated-at";
ALTER TABLE wikipedia.page_edits RENAME COLUMN created_at TO "created-at";
ALTER TABLE wikipedia.page_edits RENAME TO "page-edits";

-- wikipedia.page_views
ALTER TABLE wikipedia.page_views RENAME COLUMN page_id TO "page-id";
ALTER TABLE wikipedia.page_views RENAME COLUMN language_id TO "language-id";
ALTER TABLE wikipedia.page_views RENAME COLUMN updated_at TO "updated-at";
ALTER TABLE wikipedia.page_views RENAME COLUMN created_at TO "created-at";
ALTER TABLE wikipedia.page_views RENAME TO "page-views";

-- wikipedia.pages
ALTER TABLE wikipedia.pages RENAME COLUMN updated_at TO "updated-at";
ALTER TABLE wikipedia.pages RENAME COLUMN created_at TO "created-at";

-- yahoo.live
ALTER TABLE yahoo.live RENAME COLUMN "quote_id" TO "quote-id";
ALTER TABLE yahoo.live RENAME COLUMN "1_year_target_price" TO "1-year-target-price";
ALTER TABLE yahoo.live RENAME COLUMN "200_day_moving_average" TO "200-day-moving-average";
ALTER TABLE yahoo.live RENAME COLUMN "50_day_moving_average" TO "50-day-moving-average";
ALTER TABLE yahoo.live RENAME COLUMN "52_week_high" TO "52-week-high";
ALTER TABLE yahoo.live RENAME COLUMN "52_week_low" TO "52-week-low";
ALTER TABLE yahoo.live RENAME COLUMN "after_hours_change_real_time" TO "after-hours-change-real-time";
ALTER TABLE yahoo.live RENAME COLUMN "ask_real_time" TO "ask-real-time";
ALTER TABLE yahoo.live RENAME COLUMN "ask_size" TO "ask-size";
ALTER TABLE yahoo.live RENAME COLUMN "avg_daily_vol" TO "avg-daily-vol";
ALTER TABLE yahoo.live RENAME COLUMN "bid_real_time" TO "bid-real-time";
ALTER TABLE yahoo.live RENAME COLUMN "bid_size" TO "bid-size";
ALTER TABLE yahoo.live RENAME COLUMN "book_value" TO "book-value";
ALTER TABLE yahoo.live RENAME COLUMN "change_from_200_day_moving_average" TO "change-from-200-day-moving-average";
ALTER TABLE yahoo.live RENAME COLUMN "change_from_50_day_moving_average" TO "change-from-50-day-moving-average";
ALTER TABLE yahoo.live RENAME COLUMN "change_from_52_week_high" TO "change-from-52-week-high";
ALTER TABLE yahoo.live RENAME COLUMN "change_from_52_week_low" TO "change-from-52-week-low";
ALTER TABLE yahoo.live RENAME COLUMN "change_in_percent" TO "change-in-percent";
ALTER TABLE yahoo.live RENAME COLUMN "change_real_time" TO "change-real-time";
ALTER TABLE yahoo.live RENAME COLUMN "day_high" TO "day-high";
ALTER TABLE yahoo.live RENAME COLUMN "day_low" TO "day-low";
ALTER TABLE yahoo.live RENAME COLUMN "dividend_pay_date" TO "dividend-pay-date";
ALTER TABLE yahoo.live RENAME COLUMN "dividend_share" TO "dividend-share";
ALTER TABLE yahoo.live RENAME COLUMN "dividend_yield" TO "dividend-yield";
ALTER TABLE yahoo.live RENAME COLUMN "earnings_share" TO "earnings-share";
ALTER TABLE yahoo.live RENAME COLUMN "eps_estimate_current_year" TO "eps-estimate-current-year";
ALTER TABLE yahoo.live RENAME COLUMN "eps_estimate_next_quarter" TO "eps-estimate-next-quarter";
ALTER TABLE yahoo.live RENAME COLUMN "eps_estimate_next_year" TO "eps-estimate-next-year";
ALTER TABLE yahoo.live RENAME COLUMN "ex_dividend_date" TO "ex-dividend-date";
ALTER TABLE yahoo.live RENAME COLUMN "float_shares" TO "float-shares";
ALTER TABLE yahoo.live RENAME COLUMN "high_limit" TO "high-limit";
ALTER TABLE yahoo.live RENAME COLUMN "holdings_gain" TO "holdings-gain";
ALTER TABLE yahoo.live RENAME COLUMN "holdings_gain_real_time" TO "holdings-gain-real-time";
ALTER TABLE yahoo.live RENAME COLUMN "holdings_value_real_time" TO "holdings-value-real-time";
ALTER TABLE yahoo.live RENAME COLUMN "last_trade_date" TO "last-trade-date";
ALTER TABLE yahoo.live RENAME COLUMN "last_trade_price_only" TO "last-trade-price-only";
ALTER TABLE yahoo.live RENAME COLUMN "last_trade_size" TO "last-trade-size";
ALTER TABLE yahoo.live RENAME COLUMN "last_trade_time" TO "last-trade-time";
ALTER TABLE yahoo.live RENAME COLUMN "low_limit" TO "low-limit";
ALTER TABLE yahoo.live RENAME COLUMN "market_cap" TO "market-cap";
ALTER TABLE yahoo.live RENAME COLUMN "market_cap_real_time" TO "market-cap-real-time";
ALTER TABLE yahoo.live RENAME COLUMN "more_info" TO "more-info";
ALTER TABLE yahoo.live RENAME COLUMN "order_book_real_time" TO "order-book-real-time";
ALTER TABLE yahoo.live RENAME COLUMN "p_e_ratio" TO "p-e-ratio";
ALTER TABLE yahoo.live RENAME COLUMN "p_e_ratio_real_time" TO "p-e-ratio-real-time";
ALTER TABLE yahoo.live RENAME COLUMN "peg_ratio" TO "peg-ratio";
ALTER TABLE yahoo.live RENAME COLUMN "percent_change_from_200_day_moving_average" TO "percent-change-from-200-day-moving-average";
ALTER TABLE yahoo.live RENAME COLUMN "percent_change_from_50_day_moving_average" TO "percent-change-from-50-day-moving-average";
ALTER TABLE yahoo.live RENAME COLUMN "percent_change_from_52_week_high" TO "percent-change-from-52-week-high";
ALTER TABLE yahoo.live RENAME COLUMN "percent_change_from_52_week_low" TO "percent-change-from-52-week-low";
ALTER TABLE yahoo.live RENAME COLUMN "previous_close" TO "previous-close";
ALTER TABLE yahoo.live RENAME COLUMN "price_book" TO "price-book";
ALTER TABLE yahoo.live RENAME COLUMN "price_eps_estimate_current_year" TO "price-eps-estimate-current-year";
ALTER TABLE yahoo.live RENAME COLUMN "price_eps_estimate_next_year" TO "price-eps-estimate-next-year";
ALTER TABLE yahoo.live RENAME COLUMN "price_paid" TO "price-paid";
ALTER TABLE yahoo.live RENAME COLUMN "price_sales" TO "price-sales";
ALTER TABLE yahoo.live RENAME COLUMN "short_ratio" TO "short-ratio";
ALTER TABLE yahoo.live RENAME COLUMN "trade_date" TO "trade-date";
ALTER TABLE yahoo.live RENAME COLUMN "updated_at" TO "updated-at";
ALTER TABLE yahoo.live RENAME COLUMN "created_at" TO "created-at";

CREATE OR REPLACE FUNCTION set_created_at() RETURNS trigger AS $$
BEGIN
  IF NEW."created-at" IS NULL THEN
    NEW."created-at" := now();
  END IF;
  RETURN NEW;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION set_updated_at() RETURNS trigger AS $$
BEGIN
  NEW."updated-at" := now();
  RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP MATERIALIZED VIEW ml.features;

DROP MATERIALIZED VIEW ml.rtid;
CREATE MATERIALIZED VIEW ml.rtid AS
  SELECT "quote-id", date("created-at"), count(*) AS count
    FROM twitter.tweets
    JOIN twitter."tweets-quotes"
      ON twitter."tweets-quotes"."tweet-id" = twitter.tweets.id
   WHERE "in-reply-to-status-id" IS NOT NULL
   GROUP BY "quote-id", date("created-at");
CREATE UNIQUE INDEX "rtid-idx" ON ml.rtid ("quote-id", date);

DROP MATERIALIZED VIEW ml.rtu;
CREATE MATERIALIZED VIEW ml.rtu AS
  SELECT "quote-id", date("created-at"), count(distinct "user-id") AS count
    FROM twitter.tweets
    JOIN twitter."tweets-quotes"
      ON twitter."tweets-quotes"."tweet-id" = twitter.tweets.id
   WHERE "in-reply-to-status-id" IS NOT NULL
   GROUP BY "quote-id", date("created-at");
CREATE UNIQUE INDEX "rtu-idx" ON ml.rtu ("quote-id", date);

DROP MATERIALIZED VIEW ml.sentneg;
CREATE MATERIALIZED VIEW ml.sentneg AS
  SELECT "quote-id", date("created-at"), count(*) AS count
    FROM twitter.tweets
    JOIN twitter."tweets-quotes"
      ON twitter."tweets-quotes"."tweet-id" = twitter.tweets.id
   WHERE twitter.tweets.sentiment = 1
  GROUP BY "quote-id", date("created-at");
CREATE UNIQUE INDEX "sentneg-idx" ON ml.sentneg ("quote-id", date);

DROP MATERIALIZED VIEW ml.sentneut;
CREATE MATERIALIZED VIEW ml.sentneut AS
  SELECT "quote-id", date("created-at"), count(*) AS count
    FROM twitter.tweets
    JOIN twitter."tweets-quotes"
      ON twitter."tweets-quotes"."tweet-id" = twitter.tweets.id
   WHERE twitter.tweets.sentiment = 2
  GROUP BY "quote-id", date("created-at");
CREATE UNIQUE INDEX "sentneut-idx" ON ml.sentneut ("quote-id", date);

DROP MATERIALIZED VIEW ml.sentpos;
CREATE MATERIALIZED VIEW ml.sentpos AS
  SELECT "quote-id", date("created-at"), count(*) AS count
    FROM twitter.tweets
    JOIN twitter."tweets-quotes"
      ON twitter."tweets-quotes"."tweet-id" = twitter.tweets.id
   WHERE twitter.tweets.sentiment = 3
  GROUP BY "quote-id", date("created-at");
CREATE UNIQUE INDEX "sentpos-idx" ON ml.sentpos ("quote-id", date);

DROP MATERIALIZED VIEW ml.sentvneg;
CREATE MATERIALIZED VIEW ml.sentvneg AS
  SELECT "quote-id", date("created-at"), count(*) AS count
    FROM twitter.tweets
    JOIN twitter."tweets-quotes"
      ON twitter."tweets-quotes"."tweet-id" = twitter.tweets.id
   WHERE twitter.tweets.sentiment = 0
  GROUP BY "quote-id", date("created-at");
CREATE UNIQUE INDEX "sentvneg-idx" ON ml.sentvneg ("quote-id", date);

DROP MATERIALIZED VIEW ml.sentvpos;
CREATE MATERIALIZED VIEW ml.sentvpos AS
  SELECT "quote-id", date("created-at"), count(*) AS count
    FROM twitter.tweets
    JOIN twitter."tweets-quotes"
      ON twitter."tweets-quotes"."tweet-id" = twitter.tweets.id
   WHERE twitter.tweets.sentiment = 4
  GROUP BY "quote-id", date("created-at");
CREATE UNIQUE INDEX "sentvpos-idx" ON ml.sentvpos ("quote-id", date);

DROP MATERIALIZED VIEW ml.tday;
CREATE MATERIALIZED VIEW ml.tday AS
  SELECT date("created-at"), count(*) AS count
    FROM twitter.tweets
GROUP BY date("created-at");
CREATE UNIQUE INDEX "ml-tday-idy" ON ml.tday (date);

DROP MATERIALIZED VIEW ml.tgeo;
CREATE MATERIALIZED VIEW ml.tgeo AS
  SELECT "quote-id", date(twitter.tweets."created-at"), count(*) AS count
    FROM twitter.tweets
    JOIN twitter."tweets-quotes"
      ON twitter."tweets-quotes"."tweet-id" = twitter.tweets.id
    JOIN twitter.users
      ON twitter.users.id = twitter.tweets."user-id"
   WHERE location IS NOT NULL
     AND location !~ '^[[:space:]]*$'
   GROUP BY "quote-id", date(twitter.tweets."created-at");
CREATE UNIQUE INDEX "tgeo-idx" ON ml.tgeo ("quote-id", date);

DROP MATERIALIZED VIEW ml.thtg;
CREATE MATERIALIZED VIEW ml.thtg AS
  SELECT "quote-id", date(twitter.tweets."created-at"), count(*) AS count
    FROM twitter.tweets
    JOIN twitter."tweets-quotes"
      ON twitter."tweets-quotes"."tweet-id" = twitter.tweets.id
    JOIN twitter."hash-tags-tweets"
      ON twitter."hash-tags-tweets"."tweet-id" = twitter."tweets-quotes"."tweet-id"
   GROUP BY "quote-id", date(twitter.tweets."created-at");
CREATE UNIQUE INDEX "thtg-idx" ON ml.thtg ("quote-id", date);

DROP MATERIALIZED VIEW ml.tid;
CREATE MATERIALIZED VIEW ml.tid AS
  SELECT "quote-id", date("created-at"), count(*) AS count
    FROM twitter.tweets
    JOIN twitter."tweets-quotes"
      ON twitter."tweets-quotes"."tweet-id" = twitter.tweets.id
   GROUP BY "quote-id", date("created-at");
CREATE UNIQUE INDEX "tid-idx" ON ml.tid ("quote-id", date);

DROP MATERIALIZED VIEW ml.tuday;
CREATE MATERIALIZED VIEW ml.tuday AS
  SELECT date(twitter.tweets."created-at"), count(distinct twitter.tweets."user-id") AS count
    FROM twitter.tweets
GROUP BY date(twitter.tweets."created-at");
CREATE UNIQUE INDEX "ml-tuday-date-idx" ON ml.tuday (date);

DROP MATERIALIZED VIEW ml.turl;
CREATE MATERIALIZED VIEW ml.turl AS
  SELECT "quote-id", date(twitter.tweets."created-at"), count(*) AS count
    FROM twitter.tweets
    JOIN twitter."tweets-quotes"
      ON twitter."tweets-quotes"."tweet-id" = twitter.tweets.id
    JOIN twitter."links-tweets"
      ON twitter."links-tweets"."tweet-id" = twitter."tweets-quotes"."tweet-id"
   GROUP BY "quote-id", date(twitter.tweets."created-at");
CREATE UNIQUE INDEX "turl-idx" ON ml.turl ("quote-id", date);

DROP MATERIALIZED VIEW ml.tusm;
CREATE MATERIALIZED VIEW ml.tusm AS
  SELECT "quote-id", date("created-at"), count(*) AS count
    FROM twitter.tweets
    JOIN twitter."tweets-quotes"
      ON twitter."tweets-quotes"."tweet-id" = twitter.tweets.id
    JOIN twitter."tweets-users"
      ON twitter."tweets-users"."tweet-id" = twitter."tweets-quotes"."tweet-id"
   GROUP BY "quote-id", date("created-at");
CREATE UNIQUE INDEX "tusm-idx" ON ml.tusm ("quote-id", date);

DROP MATERIALIZED VIEW ml.uflw;
CREATE MATERIALIZED VIEW ml.uflw AS
  SELECT "quote-id", date(twitter.tweets."created-at"), avg("followers-count") AS count
    FROM twitter.tweets
    JOIN twitter."tweets-quotes"
      ON twitter."tweets-quotes"."tweet-id" = twitter.tweets.id
    JOIN twitter.users
      ON twitter.users.id = twitter.tweets."user-id"
   GROUP BY "quote-id", date(twitter.tweets."created-at");
CREATE UNIQUE INDEX "uflw-idx" ON ml.uflw ("quote-id", date);

DROP MATERIALIZED VIEW ml.ufrn;
CREATE MATERIALIZED VIEW ml.ufrn AS
  SELECT "quote-id", date(twitter.tweets."created-at"), avg("friends-count") AS count
    FROM twitter.tweets
    JOIN twitter."tweets-quotes"
      ON twitter."tweets-quotes"."tweet-id" = twitter.tweets.id
    JOIN twitter.users
      ON twitter.users.id = twitter.tweets."user-id"
   GROUP BY "quote-id", date(twitter.tweets."created-at");
CREATE UNIQUE INDEX "ufrn-idx" ON ml.ufrn ("quote-id", date);

DROP MATERIALIZED VIEW ml.uid;
CREATE MATERIALIZED VIEW ml.uid AS
  SELECT "quote-id", date(twitter.tweets."created-at"), count(distinct twitter.tweets."user-id") AS count
    FROM twitter.tweets
    JOIN twitter."tweets-quotes"
      ON twitter."tweets-quotes"."tweet-id" = twitter.tweets.id
    JOIN twitter."tweets-users"
      ON twitter."tweets-users"."tweet-id" = twitter."tweets-quotes"."tweet-id"
   GROUP BY "quote-id", date(twitter.tweets."created-at");
CREATE UNIQUE INDEX "uid-idx" ON ml.uid ("quote-id", date);

CREATE MATERIALIZED VIEW ml.features AS
     SELECT prices.date,
            prices."quote-id",
            prices.open,
            prices.close,
            prices.high,
            prices.low,
            prices.volume,
            prices."adj-close",
            prices."daily-return",
            coalesce(tday.count, 0) AS tday,
            coalesce(tuday.count, 0) AS tuday,
            coalesce(rtid.count, 0) AS rtid,
            coalesce(rtu.count, 0) AS rtu,
            coalesce(sentneg.count, 0) AS sentneg,
            coalesce(sentneut.count, 0) AS sentneut,
            coalesce(sentpos.count, 0) AS sentpos,
            coalesce(sentvneg.count, 0) AS sentvneg,
            coalesce(sentvpos.count, 0) AS sentvpos,
            coalesce(tgeo.count, 0) AS tgeo,
            coalesce(thtg.count, 0) AS thtg,
            coalesce(tid.count, 0) AS tid,
            coalesce(turl.count, 0) AS turl,
            coalesce(tusm.count, 0) AS tusm,
            coalesce(uflw.count, 0) AS uflw,
            coalesce(ufrn.count, 0) AS ufrn,
            coalesce(uid.count, 0) AS uid
       FROM prices
       JOIN ml.tday
         ON ml.tday.date = prices.date
       JOIN ml.tuday
         ON ml.tuday.date = prices.date
  LEFT JOIN ml.rtid
         ON ml.rtid.date = prices.date
        AND ml.rtid."quote-id" = prices."quote-id"
  LEFT JOIN ml.rtu
         ON ml.rtu.date = prices.date
        AND ml.rtu."quote-id" = prices."quote-id"
  LEFT JOIN ml.sentneg
         ON ml.sentneg.date = prices.date
        AND ml.sentneg."quote-id" = prices."quote-id"
  LEFT JOIN ml.sentneut
         ON ml.sentneut.date = prices.date
        AND ml.sentneut."quote-id" = prices."quote-id"
  LEFT JOIN ml.sentpos
         ON ml.sentpos.date = prices.date
        AND ml.sentpos."quote-id" = prices."quote-id"
  LEFT JOIN ml.sentvneg
         ON ml.sentvneg.date = prices.date
        AND ml.sentvneg."quote-id" = prices."quote-id"
  LEFT JOIN ml.sentvpos
         ON ml.sentvpos.date = prices.date
        AND ml.sentvpos."quote-id" = prices."quote-id"
  LEFT JOIN ml.tgeo
         ON ml.tgeo.date = prices.date
        AND ml.tgeo."quote-id" = prices."quote-id"
  LEFT JOIN ml.thtg
         ON ml.thtg.date = prices.date
        AND ml.thtg."quote-id" = prices."quote-id"
  LEFT JOIN ml.tid
         ON ml.tid.date = prices.date
        AND ml.tid."quote-id" = prices."quote-id"
  LEFT JOIN ml.turl
         ON ml.turl.date = prices.date
        AND ml.turl."quote-id" = prices."quote-id"
  LEFT JOIN ml.tusm
         ON ml.tusm.date = prices.date
        AND ml.tusm."quote-id" = prices."quote-id"
  LEFT JOIN ml.uflw
         ON ml.uflw.date = prices.date
        AND ml.uflw."quote-id" = prices."quote-id"
  LEFT JOIN ml.ufrn
         ON ml.ufrn.date = prices.date
        AND ml.ufrn."quote-id" = prices."quote-id"
  LEFT JOIN ml.uid
         ON ml.uid.date = prices.date
        AND ml.uid."quote-id" = prices."quote-id";

CREATE UNIQUE INDEX "ml-features-date-quote-id-idx" ON ml.features (date, "quote-id");
CREATE INDEX "ml-features-quote-id-idx" ON ml.features ("quote-id");

COMMIT;
