-- Revert materialize-twitter-ml-views

BEGIN;

DROP MATERIALIZED VIEW ml.tgeo;
DROP MATERIALIZED VIEW ml.tid;
DROP MATERIALIZED VIEW ml.tusm;
DROP MATERIALIZED VIEW ml.ufrn;
DROP MATERIALIZED VIEW ml.thtg;
DROP MATERIALIZED VIEW ml.turl;
DROP MATERIALIZED VIEW ml.uflw;
DROP MATERIALIZED VIEW ml.uid;

-- TGEO - NUMBER OF TWEETS WITH GEO LOCATION IN G
CREATE OR REPLACE VIEW ml.tgeo AS
  SELECT quote_id, date(twitter.tweets.created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
    JOIN twitter.users
      ON twitter.users.id = twitter.tweets.user_id
   WHERE location IS NOT NULL
     AND location !~ '^[[:space:]]*$'
   GROUP BY quote_id, date(twitter.tweets.created_at);

-- TID - NUMBER OF TWEETS IN G
CREATE OR REPLACE VIEW ml.tid AS
  SELECT quote_id, date(created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
   GROUP BY quote_id, date(created_at);

-- TUSM - NUMBER OF TWEETS THAT MENTION ANY USER IN G
CREATE OR REPLACE VIEW ml.tusm AS
  SELECT quote_id, date(created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
    JOIN twitter.tweets_users
      ON twitter.tweets_users.tweet_id = twitter.tweets_quotes.tweet_id
   GROUP BY quote_id, date(created_at);

-- UFRN - AVERAGE NUMBER OF FRIENDS FOR USER THAT POSTED IN G
CREATE OR REPLACE VIEW ml.ufrn AS
  SELECT quote_id, date(twitter.tweets.created_at), avg(friends_count) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
    JOIN twitter.users
      ON twitter.users.id = twitter.tweets.user_id
   GROUP BY quote_id, date(twitter.tweets.created_at);

-- THTG - NUMBER OF HASH TAGS USED IN ALL THE TWEETS IN G
CREATE OR REPLACE VIEW ml.thtg AS
  SELECT quote_id, date(twitter.tweets.created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
    JOIN twitter.hash_tags_tweets
      ON twitter.hash_tags_tweets.tweet_id = twitter.tweets_quotes.tweet_id
   GROUP BY quote_id, date(twitter.tweets.created_at);

-- TURL - NUMBER OF TWEETS WITH URLS IN G
CREATE OR REPLACE VIEW ml.turl AS
  SELECT quote_id, date(twitter.tweets.created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
    JOIN twitter.links_tweets
      ON twitter.links_tweets.tweet_id = twitter.tweets_quotes.tweet_id
   GROUP BY quote_id, date(twitter.tweets.created_at);

-- UFLW - AVERAGE NUMBER OF FOLLOWERS FOR USER THAT POSTED IN G
CREATE OR REPLACE VIEW ml.uflw AS
  SELECT quote_id, date(twitter.tweets.created_at), avg(followers_count) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
    JOIN twitter.users
      ON twitter.users.id = twitter.tweets.user_id
   GROUP BY quote_id, date(twitter.tweets.created_at);

-- UID - NUMBER OF DIFFERENT USERS THAT POSTED IN G
CREATE OR REPLACE VIEW ml.uid AS
  SELECT quote_id, date(twitter.tweets.created_at), count(distinct twitter.tweets.user_id) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
    JOIN twitter.tweets_users
      ON twitter.tweets_users.tweet_id = twitter.tweets_quotes.tweet_id
   GROUP BY quote_id, date(twitter.tweets.created_at);

COMMIT;
