-- Deploy create-links-table

BEGIN;

CREATE TABLE links (
  id serial PRIMARY KEY,
  url citext NOT NULL UNIQUE,
  body text NOT NULL,
  content_type citext,
  created_at timestamp with time zone NOT NULL DEFAULT now(),
  updated_at timestamp with time zone NOT NULL DEFAULT now()
);

CREATE INDEX links_content_type_idx ON links (content_type);

CREATE TRIGGER links_created_at_trigger
  BEFORE INSERT ON links FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER links_updated_at_trigger
  BEFORE UPDATE ON links FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
