(ns antistock.db.links
  (:refer-clojure :exclude [distinct group-by update])
  (:require [datumbazo.core :refer :all :exclude [deftable]]
            [datumbazo.table :refer [deftable]]))

(deftable links
  "The web links database table."
  (column :id :serial :primary-key? true)
  (column :status :integer)
  (column :body :text)
  (column :content-type :citext)
  (column :content-length :bigint)
  (column :keywords :text) ; TODO: Array
  (column :language :citext)
  (column :news-keywords :text) ; TODO: Array
  (column :text :text)
  (column :title :text)
  (column :url :citext :not-null? true :unique? true)
  (column :expanded-url :citext :not-null? true)
  (column :created-at :timestamp-with-time-zone :not-null? true :default "now()")
  (column :updated-at :timestamp-with-time-zone :not-null? true :default "now()")
  (primary-key :url)
  (has-many :tweets :schema :twitter))
