(ns antistock.db.twitter.users
  (:refer-clojure :exclude [distinct group-by update])
  (:require [datumbazo.core :refer :all :exclude [deftable]]
            [datumbazo.table :refer [deftable]]))

(deftable users
  "The Twitter users database table."
  (table :twitter.users)
  (column :id :serial :primary-key? true)
  (column :screen-name :text :not-null? true)
  (column :name :text :not-null? true)
  (column :followers-count :integer :not-null? true :default 0)
  (column :friends-count :integer :not-null? true :default 0)
  (column :retweet-count :integer :not-null? true :default 0)
  (column :statuses-count :integer :not-null? true :default 0)
  (column :listed-count :integer :not-null? true :default 0)
  (column :verified :boolean :not-null? true :default false)
  (column :possibly-sensitive :boolean :not-null? true :default false)
  (column :default-profile-image :boolean)
  (column :description :text)
  (column :lang :varchar :length 2)
  (column :location :text)
  (column :profile-image-url :text)
  (column :time-zone :text)
  (column :url :text)
  (column :utc-offset :integer)
  (column :created-at :timestamp-with-time-zone :not-null? true :default '(now))
  (column :updated-at :timestamp-with-time-zone :not-null? true :default '(now))
  (has-many :tweets))
