-- Revert underscore-to-dash

BEGIN;

-- companies
ALTER TABLE companies RENAME COLUMN "country-id" TO country_id;
ALTER TABLE companies RENAME COLUMN "sector-id" TO sector_id;
ALTER TABLE companies RENAME COLUMN "industry-id" TO industry_id;
ALTER TABLE companies RENAME COLUMN "wikipedia-page-id" TO wikipedia_page_id;
ALTER TABLE companies RENAME COLUMN "created-at" TO created_at;
ALTER TABLE companies RENAME COLUMN "updated-at" TO updated_at;

-- continents
ALTER TABLE continents RENAME COLUMN "created-at" TO created_at;
ALTER TABLE continents RENAME COLUMN "updated-at" TO updated_at;

-- countries
ALTER TABLE countries RENAME COLUMN "continent-id" TO continent_id;
ALTER TABLE countries RENAME COLUMN "iso-3166-1-alpha-2" TO iso_3166_1_alpha_2;
ALTER TABLE countries RENAME COLUMN "iso-3166-1-alpha-3" TO iso_3166_1_alpha_3;
ALTER TABLE countries RENAME COLUMN "iso-3166-1-numeric" TO iso_3166_1_numeric;
ALTER TABLE countries RENAME COLUMN "fips-code" TO fips_code;
ALTER TABLE countries RENAME COLUMN "geonames-id" TO geonames_id;
ALTER TABLE countries RENAME COLUMN "phone-prefix" TO phone_prefix;
ALTER TABLE countries RENAME COLUMN "created-at" TO created_at;
ALTER TABLE countries RENAME COLUMN "updated-at" TO updated_at;

-- exchanges
ALTER TABLE exchanges RENAME COLUMN "country-id" TO country_id;
ALTER TABLE exchanges RENAME COLUMN "created-at" TO created_at;
ALTER TABLE exchanges RENAME COLUMN "updated-at" TO updated_at;

-- industries
ALTER TABLE industries RENAME COLUMN "created-at" TO created_at;
ALTER TABLE industries RENAME COLUMN "updated-at" TO updated_at;

-- languages
ALTER TABLE languages RENAME COLUMN "iso-639-1" TO iso_639_1;
ALTER TABLE languages RENAME COLUMN "iso-639-2" TO iso_639_2;
ALTER TABLE languages RENAME COLUMN "created-at" TO created_at;
ALTER TABLE languages RENAME COLUMN "updated-at" TO updated_at;

-- links
ALTER TABLE links RENAME COLUMN "content-type" TO content_type;
ALTER TABLE links RENAME COLUMN "created-at" TO created_at;
ALTER TABLE links RENAME COLUMN "updated-at" TO updated_at;

-- links_quotes
ALTER TABLE "links-quotes" RENAME TO links_quotes;
ALTER TABLE links_quotes RENAME COLUMN "link-id" TO link_id;
ALTER TABLE links_quotes RENAME COLUMN "quote-id" TO quote_id;

-- prices
ALTER TABLE prices RENAME COLUMN "quote-id" TO quote_id;
ALTER TABLE prices RENAME COLUMN "adj-close" TO adj_close;
ALTER TABLE prices RENAME COLUMN "daily-return" TO daily_return;
ALTER TABLE prices RENAME COLUMN "created-at" TO created_at;
ALTER TABLE prices RENAME COLUMN "updated-at" TO updated_at;

-- quotes
ALTER TABLE quotes RENAME COLUMN "exchange-id" TO exchange_id;
ALTER TABLE quotes RENAME COLUMN "company-id" TO company_id;
ALTER TABLE quotes RENAME COLUMN "created-at" TO created_at;
ALTER TABLE quotes RENAME COLUMN "updated-at" TO updated_at;

-- sectors
ALTER TABLE sectors RENAME COLUMN "created-at" TO created_at;
ALTER TABLE sectors RENAME COLUMN "updated-at" TO updated_at;

-- users
ALTER TABLE users RENAME COLUMN "crypted-password" TO crypted_password;
ALTER TABLE users RENAME COLUMN "created-at" TO created_at;
ALTER TABLE users RENAME COLUMN "updated-at" TO updated_at;

-- twitter.hash_tags
ALTER TABLE twitter."hash-tags" RENAME TO hash_tags;
ALTER TABLE twitter.hash_tags RENAME COLUMN "created-at" TO created_at;
ALTER TABLE twitter.hash_tags RENAME COLUMN "updated-at" TO updated_at;

-- twitter.hash_tags_tweets
ALTER TABLE twitter."hash-tags-tweets" RENAME TO hash_tags_tweets;
ALTER TABLE twitter.hash_tags_tweets RENAME COLUMN "hash-tag-id" TO hash_tag_id;
ALTER TABLE twitter.hash_tags_tweets RENAME COLUMN "tweet-id" TO tweet_id;

-- twitter.links_tweets
ALTER TABLE twitter."links-tweets" RENAME TO links_tweets;
ALTER TABLE twitter.links_tweets RENAME COLUMN "link-id" TO link_id;
ALTER TABLE twitter.links_tweets RENAME COLUMN "tweet-id" TO tweet_id;

-- twitter.tweets
ALTER TABLE twitter.tweets RENAME COLUMN "user-id" TO user_id;
ALTER TABLE twitter.tweets RENAME COLUMN "in-reply-to-status-id" TO in_reply_to_status_id;
ALTER TABLE twitter.tweets RENAME COLUMN "in-reply-to-user-id" TO in_reply_to_user_id;
ALTER TABLE twitter.tweets RENAME COLUMN "in-reply-to-screen-name" TO in_reply_to_screen_name;
ALTER TABLE twitter.tweets RENAME COLUMN "retweet-count" TO retweet_count;
ALTER TABLE twitter.tweets RENAME COLUMN "created-at" TO created_at;
ALTER TABLE twitter.tweets RENAME COLUMN "updated-at" TO updated_at;

-- twitter.tweets_quotes
ALTER TABLE twitter."tweets-quotes" RENAME TO tweets_quotes;
ALTER TABLE twitter.tweets_quotes RENAME COLUMN "tweet-id" TO tweet_id;
ALTER TABLE twitter.tweets_quotes RENAME COLUMN "quote-id" TO quote_id;

-- twitter.tweets_users
ALTER TABLE twitter."tweets-users" RENAME TO tweets_users;
ALTER TABLE twitter.tweets_users RENAME COLUMN "tweet-id" TO tweet_id;
ALTER TABLE twitter.tweets_users RENAME COLUMN "user-id" TO user_id;

-- twitter.users
ALTER TABLE twitter.users RENAME COLUMN "screen-name" TO screen_name;
ALTER TABLE twitter.users RENAME COLUMN "followers-count" TO followers_count;
ALTER TABLE twitter.users RENAME COLUMN "friends-count" TO friends_count;
ALTER TABLE twitter.users RENAME COLUMN "listed-count" TO listed_count;
ALTER TABLE twitter.users RENAME COLUMN "retweet-count" TO retweet_count;
ALTER TABLE twitter.users RENAME COLUMN "statuses-count" TO statuses_count;
ALTER TABLE twitter.users RENAME COLUMN "possibly-sensitive" TO possibly_sensitive;
ALTER TABLE twitter.users RENAME COLUMN "time-zone" TO time_zone;
ALTER TABLE twitter.users RENAME COLUMN "utc-offset" TO utc_offset;
ALTER TABLE twitter.users RENAME COLUMN "profile-image-url" TO profile_image_url;
ALTER TABLE twitter.users RENAME COLUMN "default-profile-image" TO default_profile_image;
ALTER TABLE twitter.users RENAME COLUMN "created-at" TO created_at;
ALTER TABLE twitter.users RENAME COLUMN "updated-at" TO updated_at;

-- wikipedia.page_edits
ALTER TABLE wikipedia."page-edits" RENAME TO page_edits;
ALTER TABLE wikipedia.page_edits RENAME COLUMN "page-id" TO page_id;
ALTER TABLE wikipedia.page_edits RENAME COLUMN "edited-at" TO edited_at;
ALTER TABLE wikipedia.page_edits RENAME COLUMN "updated-at" TO updated_at;
ALTER TABLE wikipedia.page_edits RENAME COLUMN "created-at" TO created_at;

-- wikipedia.page_views
ALTER TABLE wikipedia."page-views" RENAME TO page_views;
ALTER TABLE wikipedia.page_views RENAME COLUMN "page-id" TO page_id;
ALTER TABLE wikipedia.page_views RENAME COLUMN "language-id" TO language_id;
ALTER TABLE wikipedia.page_views RENAME COLUMN "updated-at" TO updated_at;
ALTER TABLE wikipedia.page_views RENAME COLUMN "created-at" TO created_at;

-- wikipedia.pages
ALTER TABLE wikipedia.pages RENAME COLUMN "updated-at" TO updated_at;
ALTER TABLE wikipedia.pages RENAME COLUMN "created-at" TO created_at;

-- yahoo.live
ALTER TABLE yahoo.live RENAME COLUMN "quote-id" TO "quote_id";
ALTER TABLE yahoo.live RENAME COLUMN "1-year-target-price" TO "1_year_target_price";
ALTER TABLE yahoo.live RENAME COLUMN "200-day-moving-average" TO "200_day_moving_average";
ALTER TABLE yahoo.live RENAME COLUMN "50-day-moving-average" TO "50_day_moving_average";
ALTER TABLE yahoo.live RENAME COLUMN "52-week-high" TO "52_week_high";
ALTER TABLE yahoo.live RENAME COLUMN "52-week-low" TO "52_week_low";
ALTER TABLE yahoo.live RENAME COLUMN "after-hours-change-real-time" TO "after_hours_change_real_time";
ALTER TABLE yahoo.live RENAME COLUMN "ask-real-time" TO "ask_real_time";
ALTER TABLE yahoo.live RENAME COLUMN "ask-size" TO "ask_size";
ALTER TABLE yahoo.live RENAME COLUMN "avg-daily-vol" TO "avg_daily_vol";
ALTER TABLE yahoo.live RENAME COLUMN "bid-real-time" TO "bid_real_time";
ALTER TABLE yahoo.live RENAME COLUMN "bid-size" TO "bid_size";
ALTER TABLE yahoo.live RENAME COLUMN "book-value" TO "book_value";
ALTER TABLE yahoo.live RENAME COLUMN "change-from-200-day-moving-average" TO "change_from_200_day_moving_average";
ALTER TABLE yahoo.live RENAME COLUMN "change-from-50-day-moving-average" TO "change_from_50_day_moving_average";
ALTER TABLE yahoo.live RENAME COLUMN "change-from-52-week-high" TO "change_from_52_week_high";
ALTER TABLE yahoo.live RENAME COLUMN "change-from-52-week-low" TO "change_from_52_week_low";
ALTER TABLE yahoo.live RENAME COLUMN "change-in-percent" TO "change_in_percent";
ALTER TABLE yahoo.live RENAME COLUMN "change-real-time" TO "change_real_time";
ALTER TABLE yahoo.live RENAME COLUMN "day-high" TO "day_high";
ALTER TABLE yahoo.live RENAME COLUMN "day-low" TO "day_low";
ALTER TABLE yahoo.live RENAME COLUMN "dividend-pay-date" TO "dividend_pay_date";
ALTER TABLE yahoo.live RENAME COLUMN "dividend-share" TO "dividend_share";
ALTER TABLE yahoo.live RENAME COLUMN "dividend-yield" TO "dividend_yield";
ALTER TABLE yahoo.live RENAME COLUMN "earnings-share" TO "earnings_share";
ALTER TABLE yahoo.live RENAME COLUMN "eps-estimate-current-year" TO "eps_estimate_current_year";
ALTER TABLE yahoo.live RENAME COLUMN "eps-estimate-next-quarter" TO "eps_estimate_next_quarter";
ALTER TABLE yahoo.live RENAME COLUMN "eps-estimate-next-year" TO "eps_estimate_next_year";
ALTER TABLE yahoo.live RENAME COLUMN "ex-dividend-date" TO "ex_dividend_date";
ALTER TABLE yahoo.live RENAME COLUMN "float-shares" TO "float_shares";
ALTER TABLE yahoo.live RENAME COLUMN "high-limit" TO "high_limit";
ALTER TABLE yahoo.live RENAME COLUMN "holdings-gain" TO "holdings_gain";
ALTER TABLE yahoo.live RENAME COLUMN "holdings-gain-real-time" TO "holdings_gain_real_time";
ALTER TABLE yahoo.live RENAME COLUMN "holdings-value-real-time" TO "holdings_value_real_time";
ALTER TABLE yahoo.live RENAME COLUMN "last-trade-date" TO "last_trade_date";
ALTER TABLE yahoo.live RENAME COLUMN "last-trade-price-only" TO "last_trade_price_only";
ALTER TABLE yahoo.live RENAME COLUMN "last-trade-size" TO "last_trade_size";
ALTER TABLE yahoo.live RENAME COLUMN "last-trade-time" TO "last_trade_time";
ALTER TABLE yahoo.live RENAME COLUMN "low-limit" TO "low_limit";
ALTER TABLE yahoo.live RENAME COLUMN "market-cap" TO "market_cap";
ALTER TABLE yahoo.live RENAME COLUMN "market-cap-real-time" TO "market_cap_real_time";
ALTER TABLE yahoo.live RENAME COLUMN "more-info" TO "more_info";
ALTER TABLE yahoo.live RENAME COLUMN "order-book-real-time" TO "order_book_real_time";
ALTER TABLE yahoo.live RENAME COLUMN "p-e-ratio" TO "p_e_ratio";
ALTER TABLE yahoo.live RENAME COLUMN "p-e-ratio-real-time" TO "p_e_ratio_real_time";
ALTER TABLE yahoo.live RENAME COLUMN "peg-ratio" TO "peg_ratio";
ALTER TABLE yahoo.live RENAME COLUMN "percent-change-from-200-day-moving-average" TO "percent_change_from_200_day_moving_average";
ALTER TABLE yahoo.live RENAME COLUMN "percent-change-from-50-day-moving-average" TO "percent_change_from_50_day_moving_average";
ALTER TABLE yahoo.live RENAME COLUMN "percent-change-from-52-week-high" TO "percent_change_from_52_week_high";
ALTER TABLE yahoo.live RENAME COLUMN "percent-change-from-52-week-low" TO "percent_change_from_52_week_low";
ALTER TABLE yahoo.live RENAME COLUMN "previous-close" TO "previous_close";
ALTER TABLE yahoo.live RENAME COLUMN "price-book" TO "price_book";
ALTER TABLE yahoo.live RENAME COLUMN "price-eps-estimate-current-year" TO "price_eps_estimate_current_year";
ALTER TABLE yahoo.live RENAME COLUMN "price-eps-estimate-next-year" TO "price_eps_estimate_next_year";
ALTER TABLE yahoo.live RENAME COLUMN "price-paid" TO "price_paid";
ALTER TABLE yahoo.live RENAME COLUMN "price-sales" TO "price_sales";
ALTER TABLE yahoo.live RENAME COLUMN "short-ratio" TO "short_ratio";
ALTER TABLE yahoo.live RENAME COLUMN "trade-date" TO "trade_date";
ALTER TABLE yahoo.live RENAME COLUMN "updated-at" TO "updated_at";
ALTER TABLE yahoo.live RENAME COLUMN "created-at" TO "created_at";

CREATE OR REPLACE FUNCTION set_created_at() RETURNS trigger AS $$
BEGIN
  IF NEW."created_at" IS NULL THEN
    NEW."created_at" := now();
  END IF;
  RETURN NEW;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION set_updated_at() RETURNS trigger AS $$
BEGIN
  NEW."updated_at" := now();
  RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP MATERIALIZED VIEW ml.features;

DROP MATERIALIZED VIEW ml.rtid;
CREATE MATERIALIZED VIEW ml.rtid AS
  SELECT quote_id, date(created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
   WHERE in_reply_to_status_id IS NOT NULL
   GROUP BY quote_id, date(created_at);
CREATE UNIQUE INDEX rtid_idx ON ml.rtid (quote_id, date);

DROP MATERIALIZED VIEW ml.rtu;
CREATE MATERIALIZED VIEW ml.rtu AS
  SELECT quote_id, date(created_at), count(distinct user_id) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
   WHERE in_reply_to_status_id IS NOT NULL
   GROUP BY quote_id, date(created_at);
CREATE UNIQUE INDEX rtu_idx ON ml.rtu (quote_id, date);

DROP MATERIALIZED VIEW ml.sentneg;
CREATE MATERIALIZED VIEW ml.sentneg AS
  SELECT quote_id, date(created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
   WHERE twitter.tweets.sentiment = 1
  GROUP BY quote_id, date(created_at);
CREATE UNIQUE INDEX sentneg_idx ON ml.sentneg (quote_id, date);

DROP MATERIALIZED VIEW ml.sentneut;
CREATE MATERIALIZED VIEW ml.sentneut AS
  SELECT quote_id, date(created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
   WHERE twitter.tweets.sentiment = 2
  GROUP BY quote_id, date(created_at);
CREATE UNIQUE INDEX sentneut_idx ON ml.sentneut (quote_id, date);

DROP MATERIALIZED VIEW ml.sentpos;
CREATE MATERIALIZED VIEW ml.sentpos AS
  SELECT quote_id, date(created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
   WHERE twitter.tweets.sentiment = 3
  GROUP BY quote_id, date(created_at);
CREATE UNIQUE INDEX sentpos_idx ON ml.sentpos (quote_id, date);

DROP MATERIALIZED VIEW ml.sentvneg;
CREATE MATERIALIZED VIEW ml.sentvneg AS
  SELECT quote_id, date(created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
   WHERE twitter.tweets.sentiment = 0
  GROUP BY quote_id, date(created_at);
CREATE UNIQUE INDEX sentvneg_idx ON ml.sentvneg (quote_id, date);

DROP MATERIALIZED VIEW ml.sentvpos;
CREATE MATERIALIZED VIEW ml.sentvpos AS
  SELECT quote_id, date(created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
   WHERE twitter.tweets.sentiment = 4
  GROUP BY quote_id, date(created_at);
CREATE UNIQUE INDEX sentvpos_idx ON ml.sentvpos (quote_id, date);

DROP MATERIALIZED VIEW ml.tday;
CREATE MATERIALIZED VIEW ml.tday AS
  SELECT date(created_at), count(*) AS count
    FROM twitter.tweets
GROUP BY date(created_at);
CREATE UNIQUE INDEX ml_tday_idy ON ml.tday (date);

DROP MATERIALIZED VIEW ml.tgeo;
CREATE MATERIALIZED VIEW ml.tgeo AS
  SELECT quote_id, date(twitter.tweets.created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
    JOIN twitter.users
      ON twitter.users.id = twitter.tweets.user_id
   WHERE location IS NOT NULL
     AND location !~ '^[[:space:]]*$'
   GROUP BY quote_id, date(twitter.tweets.created_at);
CREATE UNIQUE INDEX tgeo_idx ON ml.tgeo (quote_id, date);

DROP MATERIALIZED VIEW ml.thtg;
CREATE MATERIALIZED VIEW ml.thtg AS
  SELECT quote_id, date(twitter.tweets.created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
    JOIN twitter.hash_tags_tweets
      ON twitter.hash_tags_tweets.tweet_id = twitter.tweets_quotes.tweet_id
   GROUP BY quote_id, date(twitter.tweets.created_at);
CREATE UNIQUE INDEX thtg_idx ON ml.thtg (quote_id, date);

DROP MATERIALIZED VIEW ml.tid;
CREATE MATERIALIZED VIEW ml.tid AS
  SELECT quote_id, date(created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
   GROUP BY quote_id, date(created_at);
CREATE UNIQUE INDEX tid_idx ON ml.tid (quote_id, date);

DROP MATERIALIZED VIEW ml.tuday;
CREATE MATERIALIZED VIEW ml.tuday AS
  SELECT date(twitter.tweets.created_at), count(distinct twitter.tweets.user_id) AS count
    FROM twitter.tweets
GROUP BY date(twitter.tweets.created_at);
CREATE UNIQUE INDEX ml_tuday_date_idx ON ml.tuday (date);

DROP MATERIALIZED VIEW ml.turl;
CREATE MATERIALIZED VIEW ml.turl AS
  SELECT quote_id, date(twitter.tweets.created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
    JOIN twitter.links_tweets
      ON twitter.links_tweets.tweet_id = twitter.tweets_quotes.tweet_id
   GROUP BY quote_id, date(twitter.tweets.created_at);
CREATE UNIQUE INDEX turl_idx ON ml.turl (quote_id, date);

DROP MATERIALIZED VIEW ml.tusm;
CREATE MATERIALIZED VIEW ml.tusm AS
  SELECT quote_id, date(created_at), count(*) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
    JOIN twitter.tweets_users
      ON twitter.tweets_users.tweet_id = twitter.tweets_quotes.tweet_id
   GROUP BY quote_id, date(created_at);
CREATE UNIQUE INDEX tusm_idx ON ml.tusm (quote_id, date);

DROP MATERIALIZED VIEW ml.uflw;
CREATE MATERIALIZED VIEW ml.uflw AS
  SELECT quote_id, date(twitter.tweets.created_at), avg(followers_count) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
    JOIN twitter.users
      ON twitter.users.id = twitter.tweets.user_id
   GROUP BY quote_id, date(twitter.tweets.created_at);
CREATE UNIQUE INDEX uflw_idx ON ml.uflw (quote_id, date);

DROP MATERIALIZED VIEW ml.ufrn;
CREATE MATERIALIZED VIEW ml.ufrn AS
  SELECT quote_id, date(twitter.tweets.created_at), avg(friends_count) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
    JOIN twitter.users
      ON twitter.users.id = twitter.tweets.user_id
   GROUP BY quote_id, date(twitter.tweets.created_at);
CREATE UNIQUE INDEX ufrn_idx ON ml.ufrn (quote_id, date);

DROP MATERIALIZED VIEW ml.uid;
CREATE MATERIALIZED VIEW ml.uid AS
  SELECT quote_id, date(twitter.tweets.created_at), count(distinct twitter.tweets.user_id) AS count
    FROM twitter.tweets
    JOIN twitter.tweets_quotes
      ON twitter.tweets_quotes.tweet_id = twitter.tweets.id
    JOIN twitter.tweets_users
      ON twitter.tweets_users.tweet_id = twitter.tweets_quotes.tweet_id
   GROUP BY quote_id, date(twitter.tweets.created_at);
CREATE UNIQUE INDEX uid_idx ON ml.uid (quote_id, date);

CREATE MATERIALIZED VIEW ml.features AS
     SELECT prices.date,
            prices.quote_id,
            prices.open,
            prices.close,
            prices.high,
            prices.low,
            prices.volume,
            prices.adj_close,
            prices.daily_return,
            coalesce(tday.count, 0) AS tday,
            coalesce(tuday.count, 0) AS tuday,
            coalesce(rtid.count, 0) AS rtid,
            coalesce(rtu.count, 0) AS rtu,
            coalesce(sentneg.count, 0) AS sentneg,
            coalesce(sentneut.count, 0) AS sentneut,
            coalesce(sentpos.count, 0) AS sentpos,
            coalesce(sentvneg.count, 0) AS sentvneg,
            coalesce(sentvpos.count, 0) AS sentvpos,
            coalesce(tgeo.count, 0) AS tgeo,
            coalesce(thtg.count, 0) AS thtg,
            coalesce(tid.count, 0) AS tid,
            coalesce(turl.count, 0) AS turl,
            coalesce(tusm.count, 0) AS tusm,
            coalesce(uflw.count, 0) AS uflw,
            coalesce(ufrn.count, 0) AS ufrn,
            coalesce(uid.count, 0) AS uid
       FROM prices
       JOIN ml.tday
         ON ml.tday.date = prices.date
       JOIN ml.tuday
         ON ml.tuday.date = prices.date
  LEFT JOIN ml.rtid
         ON ml.rtid.date = prices.date
        AND ml.rtid.quote_id = prices.quote_id
  LEFT JOIN ml.rtu
         ON ml.rtu.date = prices.date
        AND ml.rtu.quote_id = prices.quote_id
  LEFT JOIN ml.sentneg
         ON ml.sentneg.date = prices.date
        AND ml.sentneg.quote_id = prices.quote_id
  LEFT JOIN ml.sentneut
         ON ml.sentneut.date = prices.date
        AND ml.sentneut.quote_id = prices.quote_id
  LEFT JOIN ml.sentpos
         ON ml.sentpos.date = prices.date
        AND ml.sentpos.quote_id = prices.quote_id
  LEFT JOIN ml.sentvneg
         ON ml.sentvneg.date = prices.date
        AND ml.sentvneg.quote_id = prices.quote_id
  LEFT JOIN ml.sentvpos
         ON ml.sentvpos.date = prices.date
        AND ml.sentvpos.quote_id = prices.quote_id
  LEFT JOIN ml.tgeo
         ON ml.tgeo.date = prices.date
        AND ml.tgeo.quote_id = prices.quote_id
  LEFT JOIN ml.thtg
         ON ml.thtg.date = prices.date
        AND ml.thtg.quote_id = prices.quote_id
  LEFT JOIN ml.tid
         ON ml.tid.date = prices.date
        AND ml.tid.quote_id = prices.quote_id
  LEFT JOIN ml.turl
         ON ml.turl.date = prices.date
        AND ml.turl.quote_id = prices.quote_id
  LEFT JOIN ml.tusm
         ON ml.tusm.date = prices.date
        AND ml.tusm.quote_id = prices.quote_id
  LEFT JOIN ml.uflw
         ON ml.uflw.date = prices.date
        AND ml.uflw.quote_id = prices.quote_id
  LEFT JOIN ml.ufrn
         ON ml.ufrn.date = prices.date
        AND ml.ufrn.quote_id = prices.quote_id
  LEFT JOIN ml.uid
         ON ml.uid.date = prices.date
        AND ml.uid.quote_id = prices.quote_id;

CREATE UNIQUE INDEX ml_features_date_quote_id_idx ON ml.features (date, quote_id);
CREATE INDEX ml_features_quote_id_idx ON ml.features (quote_id);

COMMIT;
