(ns antistock.worker.main
  (:require [antistock.config.core :refer [config]]
            [antistock.system :as system]
            [antistock.util :refer [log-banner]]
            [antistock.worker.system :refer [new-system]]
            [commandline.core :refer [print-help with-commandline]]
            [com.stuartsierra.component :as component]
            [environ.core :refer [env]])
  (:gen-class))

(defn run [& [opts]]
  (let [config (config env)]
    (system/with-component [system (new-system config)]
      (system/on-shutdown #(component/stop system))
      (while true (Thread/sleep 1000)))))

(defn -main [& args]
  (with-commandline [[args] args]
    [[h help "Print this help."]]
    (when help
      (print-help "antistock-worker")
      (System/exit 0))
    (log-banner)
    (run)))
