(ns antistock.worker.system
  (:require [antistock.db.system :as db]
            [antistock.queue :as queue]
            [antistock.worker.twitter :as twitter]
            [antistock.worker.wikipedia.views :as wikipedia-views]
            [com.stuartsierra.component :as component]))

(defn new-system
  "Make a new worker system."
  [{:keys [broker db twitter wikipedia-views]}]
  (-> (component/system-map
       :broker (queue/new-broker broker)
       :db (db/new-db db)
       :twitter (twitter/new-worker twitter)
       :wikipedia-views (wikipedia-views/new-worker wikipedia-views))
      (component/system-using
       {:twitter [:broker :db]
        :wikipedia-views [:broker :db]})))
