(defproject antistock/zookeeper "0.1.5"
  :description "Antistock Zookeeper"
  :url "https://bitbucket.org/r0man/antistock-zookeeper"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :dependencies [[com.stuartsierra/component "0.3.1"]
                 [org.clojure/clojure "1.8.0"]
                 [org.clojure/tools.logging "0.3.1"]
                 [prismatic/schema "1.1.1"]
                 [zookeeper-clj "0.9.4"
                  :exclusions [org.apache.zookeeper/zookeeper
                               org.slf4j/slf4j-log4j12]]
                 [org.apache.zookeeper/zookeeper "3.4.8"
                  :exclusions [org.slf4j/slf4j-log4j12]]]
  :deploy-repositories [["releases" :clojars]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]}
  :min-lein-version "2.4.2"
  :profiles {:dev {:dependencies [[ch.qos.logback/logback-core "1.1.7"]
                                  [ch.qos.logback/logback-classic "1.1.7"]
                                  [org.slf4j/log4j-over-slf4j "1.7.21"]
                                  [reloaded.repl "0.2.1"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]}
             :test {:resource-paths ["test-resources"]}})
