(use '[caribou.config :only (read-config configure environment)])
(require '[clojure.java.io :as io]
         '[caribou.logger :as log])

(def default-config
  {:debug        true
   :use-database true
   :halo-enabled true
   :halo-prefix "/_halo"
   :halo-key    "replace-with-halo-key"
   :halo-hosts  ["http://127.0.0.1:33333" "http://127.0.0.1:33663"]
   :template-dir   "resources/templates"
   :api-swank-port 9002
   :public-dir     "public"
   :asset-dir      "./"
   :hooks-ns      "weareinstrumentv3.hooks"
   :migrations-dir "./migrations"
   :api-public     "resources/public"
   :controller-ns  "weareinstrumentv3.controllers"})

(defn submerge
  [a b]
  (if (string? b) b (merge a b)))

(defn get-config
  []
  (let [config-file (format "config/%s.clj" (name (environment)))]
    (log/notice (str "Loading Caribou config " config-file))
    (merge-with submerge default-config (read-config (io/resource config-file)))))

;;  (merge-with submerge default-config (read-config (clojure.java.io/resource "config/development.clj"))))

;; This call is required by Caribou
(configure (get-config))
