(ns weareinstrumentv3.migrations.fix-status-order
  (:require [caribou.util :as util]
            [caribou.db :as db]
            [caribou.config :as config]
            [caribou.model :as model]
            [caribou.migrations.bootstrap :as bootstrap]))

(defn migrate []
  (config/init)
  (model/init)
  (doseq [m (model/gather :model {:include {:fields {}}})]
    (let [field-count           (count (:fields m))
          status-id-field       (model/pick :field {:where {:name "Status Id" :model_id (:id m)}})
          status-position-field (model/pick :field {:where {:name "Status Position" :model_id (:id m)}})
          status-field          (model/pick :field {:where {:name "Status" :model_id (:id m)}})
          _ (println status-id-field status-position-field status-field)]
      (when (and (and status-id-field status-position-field) status-field)
        (do
          (model/update :field (:id status-id-field) {:model_position field-count})
          (model/update :field (:id status-position-field) {:model_position (inc field-count)})
          (model/update :field (:id status-field) {:model_position (inc (inc field-count))})))))
  (let [status-model (model/pick :model {:where {:slug "status"}})
        name-field (model/pick :field {:where {:name "Name" :model_id (:id status-model)}})]
    (model/update :field (:id name-field) {:model_position 0})))