(ns caribou.app.sessions.cassandra
  (:use [ring.middleware.session.store]
        [clj-hector.core])
  (:import java.util.UUID))

; This is a ring-compatible implementation of a session store for Cassandra
;FIXME needs type-aware serialization!

(defrecord CassandraStore [ks cf]
  SessionStore
  (read-session [this session-id]
    (if session-id
      (let [session-val (get (first (get-rows ks cf [session-id] :n-serializer :keyword :v-serializer :string)) session-id)]
        (if (not (empty? session-val))
          (read-string (:value session-val))))))
  (write-session [this session-id data]
    (let [session-id (or session-id (str (UUID/randomUUID)))]
      (put ks cf session-id {:value (pr-str data)} :n-serializer :keyword :v-serializer :string)
      session-id))
  (delete-session [this session-id]
    (delete-rows ks cf [session-id])
    nil))

(defn cassandra-store
  [cluster-name cluster-hosts keyspace-name column-family]
  (let [cassandra-cluster (cluster cluster-name cluster-hosts)
        cassandra-keyspace (keyspace cassandra-cluster keyspace-name)]
    (CassandraStore. cassandra-keyspace column-family)))
