(ns image-resizer.core
  (:require
   [clojure.string   :as str]
   [image-resizer.fs :as fs]
   [image-resizer.resize :refer :all]
   [image-resizer.crop :refer :all]
   [image-resizer.util :refer [buffered-image]]))

(defn dimensions [image]
  [(.getWidth image) (.getHeight image)])

(defn resize-to-width [image width]
  ((resize-width-fn width) image))

(defn resize-to-height [image height]
  ((resize-height-fn height) image))

(defn resize [image width height]
  ((resize-fn width height) image))

(defn force-resize [image width height]
  ((force-resize-fn width height) image))

(defn crop [image width height]
  ((crop-fn 0 0 width height) image))

(defn crop-to-width [image width]
  ((crop-width-fn width) image))

(defn crop-to-height [image height]
  ((crop-height-fn height) image))

(defn crop-from [image x y width height]
  ((crop-fn x y width height) image))

(defn resize-and-crop [image width height]
  (->
   image
   ((resize-fn width height))
   ((crop-fn 0 0 width height))))

(defn resize-to-fill [image width height]
  (let [buffered (buffered-image image)
        [original-width original-height] (dimensions buffered)
        resize-fn (if (<= original-width original-height)
                    (resize-width-fn width)
                    (resize-height-fn height))
        resized-image (resize-fn image)
        [new-width new-height] (dimensions resized-image)
        x (int (/ (- new-width width) 2))
        y (int (/ (- new-height height) 2))]
    ((crop-fn x y width height) resized-image)))
