/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.LogContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class Log2Formatter
extends Formatter {
    private DateFormat dateFormatter;

    public Log2Formatter() {
        this.dateFormatter = new SimpleDateFormat("yyMMdd HH:mm:ss.SSS");
    }

    public Log2Formatter(DateFormat val) {
        this.dateFormatter = val;
    }

    public String format(LogRecord rec) {
        String threadTag = LogContext.getThreadTag();
        threadTag = threadTag == null ? "" : threadTag + " ";
        StringBuilder sb = new StringBuilder();
        String timestamp = this.dateFormatter.format(new Date(rec.getMillis()));
        int levelPrefix = this.getLevelPrefix(rec.getLevel().intValue());
        StringTokenizer tokenizer = new StringTokenizer(this.formatMessage(rec), "\n");
        while (tokenizer.hasMoreTokens()) {
            sb.append(timestamp);
            sb.append(':');
            sb.append((char)levelPrefix);
            sb.append(' ');
            sb.append(threadTag);
            sb.append(tokenizer.nextToken());
            sb.append("\n");
            levelPrefix = 32;
        }
        Throwable thrown = rec.getThrown();
        if (thrown != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            thrown.printStackTrace(pw);
            pw.flush();
            sb.append(sw.toString());
        }
        return sb.toString();
    }

    private char getLevelPrefix(int recLevel) {
        if (recLevel >= Level.WARNING.intValue()) {
            return 'X';
        }
        if (recLevel <= Level.FINE.intValue()) {
            return 'D';
        }
        return 'I';
    }
}

