/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import java.security.SecureRandom;
import java.util.Random;

public final class Randoms {
    private static final Random RANDOM = new ReadOnlyRandom();
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    private Randoms() {
    }

    public static SecureRandom secureRandom() {
        return SECURE_RANDOM;
    }

    public static SecureRandom secureRandom(byte[] seed) {
        return new SecureRandom(seed);
    }

    public static Random insecureRandom() {
        return RANDOM;
    }

    public static Random insecureRandom(long seed) {
        return new Random(seed);
    }

    private static class ReadOnlyRandom
    extends Random {
        private static final long serialVersionUID = 898001275432099254L;
        private boolean initializationComplete = true;

        private ReadOnlyRandom() {
        }

        public void setSeed(long seed) {
            if (this.initializationComplete) {
                throw new UnsupportedOperationException("Setting the seed on the shared Random object is not permitted");
            }
            super.setSeed(seed);
        }
    }
}

