/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base.genfiles;

import com.google.appengine.repackaged.com.google.common.base.HashBase;
import com.google.appengine.repackaged.com.google.common.base.X;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongObjectMap
implements Iterable<Entry> {
    private static final long EMPTY_KEY = -1L;
    private static final long DELETED_KEY = -2L;
    private long[] table;
    private Object[] value;
    private int count;
    private int bits1;
    private int bits2;
    private int enlarge_threshold;
    private int lookups;
    private int probes;
    private int deleted;
    private int shrink_threshold;
    private static final float MAX_OCCUPANCY = 0.8f;
    private static final float MIN_OCCUPANCY = 0.1f;
    private static long[] empty_table = new long[0];
    private long last_stats = System.currentTimeMillis();
    private final boolean silent_;

    public LongObjectMap() {
        this(4);
    }

    public LongObjectMap(int n) {
        this(n, false);
    }

    public LongObjectMap(int n, boolean silent) {
        this.silent_ = silent;
        this.table = empty_table;
        this.resize(Math.max(3, n));
    }

    public void insert(long key, Object val) {
        int index = this.find_index(key);
        long old_elem = this.table[index];
        this.table[index] = key;
        this.value[index] = val;
        if (old_elem == -1L) {
            ++this.count;
            if (this.count + this.deleted >= this.enlarge_threshold) {
                this.resize(this.count * 2);
            }
        } else if (old_elem == -2L) {
            ++this.count;
            --this.deleted;
        }
    }

    public boolean contains(long key) {
        long elem = this.table[this.find_index(key)];
        return elem != -1L && elem != -2L;
    }

    public Object lookup(long key, Object default_value) {
        int index = this.find_index(key);
        long k = this.table[index];
        if (k == -1L || k == -2L) {
            return default_value;
        }
        return this.value[index];
    }

    public boolean remove(long key) {
        int index = this.find_index(key);
        long elem = this.table[index];
        if (elem == -1L || elem == -2L) {
            return false;
        }
        this.table[index] = -2L;
        this.value[index] = null;
        --this.count;
        ++this.deleted;
        if (this.count < this.shrink_threshold) {
            this.resize(this.count);
        }
        return true;
    }

    public int size() {
        return this.count;
    }

    public int next(int i) {
        ++i;
        while (i < this.table.length) {
            long key = this.table[i];
            if (key != -1L && key != -2L) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Iterator<Long> keyIterator() {
        return new HashIterator<Long>(this){

            @Override
            public Long next() {
                return this.map.keyAt(this.nextIndex());
            }
        };
    }

    public Iterator<Object> valueIterator() {
        return new HashIterator<Object>(this){

            @Override
            public Object next() {
                return this.map.valueAt(this.nextIndex());
            }
        };
    }

    @Override
    public Iterator<Entry> iterator() {
        return new HashIterator<Entry>(this){

            @Override
            public Entry next() {
                int next = this.nextIndex();
                return new Entry(this.map.keyAt(next), this.map.valueAt(next));
            }
        };
    }

    public Object[] toValueArray() {
        Object[] array = new Object[this.size()];
        int arrayIndex = 0;
        int mapIndex = -1;
        while ((mapIndex = this.next(mapIndex)) >= 0 && arrayIndex < array.length) {
            array[arrayIndex++] = this.valueAt(mapIndex);
        }
        return array;
    }

    public long keyAt(int i) {
        return this.table[i];
    }

    public Object valueAt(int i) {
        return this.value[i];
    }

    public void setValueAt(int i, Object v) {
        this.value[i] = v;
    }

    public void removeAt(int i) {
        X.assertTrue(this.table[i] != -2L);
        X.assertTrue(this.table[i] != -1L);
        this.table[i] = -2L;
        --this.count;
        ++this.deleted;
    }

    private int find_index(long key) {
        ++this.lookups;
        int n = this.table.length;
        int mult = HashBase.hash(key) * -820265764 & Integer.MAX_VALUE;
        int h1 = mult >>> this.bits1 & n - 1;
        int h2 = mult >>> this.bits2 & n - 1 | 1;
        int index = h1;
        int deleted_index = -1;
        for (int i = 0; i < n; ++i) {
            ++this.probes;
            if (this.table[index] == -2L) {
                if (deleted_index < 0) {
                    deleted_index = index;
                }
            } else {
                if (this.table[index] == -1L) {
                    return deleted_index >= 0 ? deleted_index : index;
                }
                if (key == this.table[index]) {
                    return index;
                }
            }
            index = index + h2 & n - 1;
        }
        throw new RuntimeException("Did not find empty slot for " + key);
    }

    public void resize(int desired) {
        int i;
        if (desired < this.count) {
            desired = this.count;
        }
        int min_size = (int)((float)desired / 0.8f);
        int lg = 2;
        while (1 << lg < min_size) {
            ++lg;
        }
        int n = 1 << lg;
        if (n == this.count) {
            return;
        }
        long[] old = this.table;
        this.table = new long[n];
        Object[] oldval = this.value;
        this.value = new Object[n];
        this.enlarge_threshold = Math.min(n - 1, (int)((float)n * 0.8f));
        X.assertTrue(this.enlarge_threshold < n);
        this.count = 0;
        this.bits2 = Math.max(31 - 2 * lg, 0);
        this.bits1 = 31 - lg;
        this.shrink_threshold = (int)((float)n * 0.1f);
        if (this.shrink_threshold <= 10) {
            this.shrink_threshold = 1;
        }
        this.deleted = 0;
        X.assertTrue(this.shrink_threshold < this.enlarge_threshold);
        X.assertTrue(this.shrink_threshold >= 0);
        for (i = 0; i < n; ++i) {
            this.table[i] = -1L;
        }
        for (i = 0; i < old.length; ++i) {
            long elem = old[i];
            if (elem == -1L || elem == -2L) continue;
            this.insert(elem, oldval[i]);
        }
        if (!(this.table.length < 131072 && old.length < 131072 || this.silent_)) {
            this.stats("resize");
        }
    }

    public void stats(String label) {
        long now = System.currentTimeMillis();
        System.err.println((double)(now - this.last_stats) / 1000.0 + " " + label + " " + this.count + " cnt; " + this.table.length + " sz; " + this.enlarge_threshold + " th; " + this.lookups + "/" + this.probes);
        this.last_stats = now;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class HashIterator<E>
    implements Iterator<E> {
        private int nextIndex;
        private int currentIndex;
        LongObjectMap map;

        private HashIterator(LongObjectMap map) {
            this.map = map;
            this.nextIndex = map.next(-1);
            this.currentIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        int nextIndex() {
            this.currentIndex = this.nextIndex;
            this.nextIndex = this.map.next(this.currentIndex);
            return this.currentIndex;
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException();
            }
            this.map.removeAt(this.currentIndex);
            this.nextIndex = this.map.next(this.currentIndex);
            this.currentIndex = -1;
        }
    }

    public static class Entry {
        private final long key;
        private final Object value;

        public Entry(long k, Object v) {
            this.key = k;
            this.value = v;
        }

        public long getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

