/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.users.dev.LoginCookieUtils;
import com.google.appengine.tools.development.LocalEnvironment;
import com.google.apphosting.utils.config.AppEngineWebXml;
import javax.servlet.http.HttpServletRequest;

class LocalHttpRequestEnvironment
extends LocalEnvironment {
    static final String DEFAULT_NAMESPACE_HEADER = "X-AppEngine-Default-Namespace";
    static final String CURRENT_NAMESPACE_HEADER = "X-AppEngine-Current-Namespace";
    private static final String CURRENT_NAMESPACE_KEY = NamespaceManager.class.getName() + ".currentNamespace";
    private static final String USER_ID_KEY = "com.google.appengine.api.users.UserService.user_id_key";
    private static final String USER_ORGANIZATION_KEY = "com.google.appengine.api.users.UserService.user_organization";
    private final LoginCookieUtils.CookieData loginCookieData;
    private String requestNamespace;

    public LocalHttpRequestEnvironment(AppEngineWebXml appEngineWebXml, HttpServletRequest request) {
        super(appEngineWebXml);
        String currentNamespace;
        this.loginCookieData = LoginCookieUtils.getCookieData((HttpServletRequest)request);
        this.requestNamespace = request.getHeader(DEFAULT_NAMESPACE_HEADER);
        if (this.requestNamespace == null) {
            this.requestNamespace = "";
        }
        if ((currentNamespace = request.getHeader(CURRENT_NAMESPACE_HEADER)) != null) {
            this.attributes.put(CURRENT_NAMESPACE_KEY, currentNamespace);
        }
        if (this.loginCookieData != null) {
            this.attributes.put(USER_ID_KEY, this.loginCookieData.getUserId());
            this.attributes.put(USER_ORGANIZATION_KEY, "");
        }
    }

    public boolean isLoggedIn() {
        return this.loginCookieData != null;
    }

    public String getEmail() {
        if (this.loginCookieData == null) {
            return null;
        }
        return this.loginCookieData.getEmail();
    }

    public boolean isAdmin() {
        if (this.loginCookieData == null) {
            return false;
        }
        return this.loginCookieData.isAdmin();
    }

    public String getRequestNamespace() {
        return this.requestNamespace;
    }
}

