/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.net.base.CidrAddressBlock;
import com.google.apphosting.utils.config.AppEngineConfigException;
import java.util.ArrayList;
import java.util.List;

public class DosXml {
    private List<BlacklistEntry> blacklistEntries = new ArrayList<BlacklistEntry>();

    public BlacklistEntry addNewBlacklistEntry() {
        this.validateLastEntry();
        BlacklistEntry entry = new BlacklistEntry();
        this.blacklistEntries.add(entry);
        return entry;
    }

    public void validateLastEntry() {
        if (this.blacklistEntries.size() == 0) {
            return;
        }
        BlacklistEntry last = this.blacklistEntries.get(this.blacklistEntries.size() - 1);
        if (last.getSubnet() == null) {
            throw new AppEngineConfigException("no subnet for blacklist");
        }
    }

    public String toYaml() {
        StringBuilder builder = new StringBuilder("blacklist:\n");
        for (BlacklistEntry ent : this.blacklistEntries) {
            builder.append("- subnet: " + ent.getSubnet() + "\n");
            if (ent.getDescription().equals("")) continue;
            builder.append("  description: " + ent.getDescription() + "\n");
        }
        return builder.toString();
    }

    public class BlacklistEntry {
        String subnet = null;
        String desc = "";

        public void setDescription(String description) {
            this.desc = description.replaceAll("\n", " ");
        }

        public void setSubnet(String subnet) {
            try {
                CidrAddressBlock parsedSubnet = CidrAddressBlock.create(subnet);
                this.subnet = subnet;
            }
            catch (IllegalArgumentException iae) {
                this.subnet = null;
                throw new AppEngineConfigException("subnet " + subnet + " failed to parse", iae.getCause());
            }
        }

        public String getSubnet() {
            return this.subnet;
        }

        public String getDescription() {
            return this.desc;
        }
    }
}

