/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.GenerationDirectory;
import com.google.apphosting.utils.config.IndexesXml;
import java.io.File;
import java.io.InputStream;
import java.util.Stack;
import java.util.logging.Level;
import org.mortbay.xml.XmlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexesXmlReader
extends AbstractConfigXmlReader<IndexesXml> {
    public static final String GENERATED_INDEX_FILENAME = "datastore-indexes-auto.xml";
    public static final String INDEX_FILENAME = "datastore-indexes.xml";
    public static final String AUTOINDEX_TAG = "auto-update";
    private static final String FILENAME = "WEB-INF/datastore-indexes.xml";
    private static final String INDEXES_TAG = "datastore-indexes";
    private static final String INDEX_TAG = "datastore-index";
    private static final String KIND_PROP = "kind";
    private static final String ANCESTORS_PROP = "ancestor";
    private static final String ANCESTORS_VALUE_YES = "true";
    private static final String ANCESTORS_VALUE_NO = "false";
    private static final String PROPERTY_TAG = "property";
    private static final String NAME_PROP = "name";
    private static final String DIRECTION_PROP = "direction";
    private static final String DIRECTION_VALUE_ASC = "asc";
    private static final String DIRECTION_VALUE_DESC = "desc";
    private IndexesXml indexesXml;

    public IndexesXmlReader(String appDir) {
        super(appDir, false);
    }

    public IndexesXml readIndexesXml() {
        return this.readConfigXml();
    }

    @Override
    protected IndexesXml readConfigXml() {
        InputStream is = null;
        String filename = null;
        this.indexesXml = new IndexesXml();
        try {
            if (this.fileExists()) {
                filename = this.getFilename();
                is = this.getInputStream();
                this.processXml(is);
                this.logger.info("Successfully processed " + filename);
            }
            if (this.generatedFileExists()) {
                filename = this.getGeneratedFile().getPath();
                is = this.getGeneratedStream();
                this.processXml(is);
                this.logger.info("Successfully processed " + filename);
            }
        }
        catch (Exception e) {
            try {
                String msg = "Received exception processing " + filename;
                this.logger.log(Level.SEVERE, msg, e);
                if (e instanceof AppEngineConfigException) {
                    throw (AppEngineConfigException)e;
                }
                throw new AppEngineConfigException(msg, e);
            }
            catch (Throwable throwable) {
                this.close(is);
                throw throwable;
            }
        }
        this.close(is);
        return this.indexesXml;
    }

    @Override
    protected IndexesXml processXml(InputStream is) {
        this.parse(new AbstractConfigXmlReader.ParserCallback(){
            boolean first = true;
            IndexesXml.Index index;

            @Override
            public void newNode(XmlParser.Node node, Stack<XmlParser.Node> ancestors) {
                switch (ancestors.size()) {
                    case 0: {
                        if (!IndexesXmlReader.INDEXES_TAG.equalsIgnoreCase(node.getTag())) {
                            throw new AppEngineConfigException(IndexesXmlReader.this.getFilename() + " does not contain <" + IndexesXmlReader.INDEXES_TAG + ">");
                        }
                        if (!this.first) {
                            throw new AppEngineConfigException(IndexesXmlReader.this.getFilename() + " contains multiple <" + IndexesXmlReader.INDEXES_TAG + ">");
                        }
                        this.first = false;
                        break;
                    }
                    case 1: {
                        if (IndexesXmlReader.INDEX_TAG.equalsIgnoreCase(node.getTag())) {
                            String kind = node.getAttribute(IndexesXmlReader.KIND_PROP);
                            if (kind == null) {
                                throw new AppEngineConfigException(IndexesXmlReader.this.getFilename() + " has <" + IndexesXmlReader.INDEX_TAG + "> missing required attribute \"" + IndexesXmlReader.KIND_PROP + "\"");
                            }
                            String anc = node.getAttribute(IndexesXmlReader.ANCESTORS_PROP).toLowerCase();
                            boolean ancestorProp = false;
                            if (anc != null) {
                                if (anc.equals(IndexesXmlReader.ANCESTORS_VALUE_YES)) {
                                    ancestorProp = true;
                                } else if (!anc.equals(IndexesXmlReader.ANCESTORS_VALUE_NO)) {
                                    throw new AppEngineConfigException(IndexesXmlReader.this.getFilename() + " has <" + IndexesXmlReader.INDEX_TAG + "> with attribute \"" + IndexesXmlReader.ANCESTORS_PROP + "\" not \"" + IndexesXmlReader.ANCESTORS_VALUE_YES + "\" or \"" + IndexesXmlReader.ANCESTORS_VALUE_NO + "\"");
                                }
                            }
                            this.index = IndexesXmlReader.this.indexesXml.addNewIndex(kind, ancestorProp);
                            break;
                        }
                        throw new AppEngineConfigException(IndexesXmlReader.this.getFilename() + " contains <" + node.getTag() + "> instead of <" + IndexesXmlReader.INDEX_TAG + "/>");
                    }
                    case 2: {
                        assert (this.index != null);
                        if (IndexesXmlReader.PROPERTY_TAG.equalsIgnoreCase(node.getTag())) {
                            String name = node.getAttribute(IndexesXmlReader.NAME_PROP);
                            if (name == null) {
                                throw new AppEngineConfigException(IndexesXmlReader.this.getFilename() + " has <" + IndexesXmlReader.PROPERTY_TAG + "> missing required attribute \"" + IndexesXmlReader.NAME_PROP + "\"");
                            }
                            String direction = node.getAttribute(IndexesXmlReader.DIRECTION_PROP).toLowerCase();
                            boolean ascending = true;
                            if (direction != null) {
                                if (direction.equals(IndexesXmlReader.DIRECTION_VALUE_DESC)) {
                                    ascending = false;
                                } else if (!direction.equals(IndexesXmlReader.DIRECTION_VALUE_ASC)) {
                                    throw new AppEngineConfigException(IndexesXmlReader.this.getFilename() + " has <" + IndexesXmlReader.PROPERTY_TAG + "> with attribute \"" + IndexesXmlReader.DIRECTION_PROP + "\" not \"" + IndexesXmlReader.DIRECTION_VALUE_ASC + "\" or \"" + IndexesXmlReader.DIRECTION_VALUE_DESC + "\"");
                                }
                            }
                            this.index.addNewProperty(name, ascending);
                            break;
                        }
                        throw new AppEngineConfigException(IndexesXmlReader.this.getFilename() + " contains <" + node.getTag() + "> instead of <" + IndexesXmlReader.PROPERTY_TAG + "/>");
                    }
                    default: {
                        throw new AppEngineConfigException(IndexesXmlReader.this.getFilename() + " has a syntax error; node <" + node.getTag() + "> is too deeply nested to be valid.");
                    }
                }
            }
        }, is);
        return this.indexesXml;
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }

    @Override
    protected File getGeneratedFile() {
        File genFile = new File(GenerationDirectory.getGenerationDirectory(new File(this.appDir)), GENERATED_INDEX_FILENAME);
        return genFile;
    }
}

