(ns leiningen.new.appengine-skeleton
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "appengine-skeleton"))

(defn appengine-skeleton
  "Generate a new project for use on App Engine."
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' appengine-skeleton project.")
    (->files data
             ["README.md" (render "README.md" data)]
             ["project.clj" (render "project.clj" data)]
             ["src/{{sanitized}}/servlet.clj" (render "servlet.clj" data)]
             ["war-resources/WEB-INF/appengine-web.xml" (render "appengine-web.xml" data)]
             ["war-resources/WEB-INF/web.xml" (render "web.xml" data)]
             ["war-resources/WEB-INF/logging.properties" (render "logging.properties" data)])))
