(def war-path (str "target/{{name}}-0.1.0-SNAPSHOT/"))

(defproject {{name}} "0.1.0-SNAPSHOT"
  :description "FIXME: write description"
  :url "http://{{name}}.appspot.com"
  :license {:name "FIXME: choose"
            :url "http://example.com/FIXME"}
  :dependencies [[org.clojure/clojure "1.7.0"]
                 [org.clojure/clojurescript "1.7.228"]
                 [org.clojure/core.async "0.2.374"]
                 [org.clojure/tools.logging "0.3.1"]
                 [appkit "0.1.5-SNAPSHOT"]
                 [netkit "0.1.0-SNAPSHOT"]
                 [uikit "0.1.2-SNAPSHOT"]
                 [org.slf4j/slf4j-jdk14 "1.7.16"]
                 [compojure "1.4.0"]
                 [garden "1.2.1"]
                 [cljsjs/tether "1.1.1-0"]
                 [cljsjs/bootstrap "4.0.0-alpha.2-0"]
                 [org.webjars/bootstrap "4.0.0-alpha.2"]]
  :pedantic? false ;; mapreduce library
  :plugins [[lein-appengine "0.1.1-SNAPSHOT"]
            [lein-garden "0.2.7-SNAPSHOT"]]
  :prep-tasks [["garden" "once"]]
  :resource-paths ["resources" "target/cljs" "target/css"]
  :cljsbuild {:builds
              {:default
               {:source-paths ["src"]
                :compiler
                {:output-to "target/cljs/public/main.js"
                 :output-dir "target/cljs/public/out"}}}}
  :garden {:builds [{:source-paths ["src"]
                     :stylesheet {{name}}.design/styles
                     :compiler {:output-to "target/css/public/main.css"}}]}
  :appengine {:handler {{name}}.api/handler}
  :profiles
  {;; REPL, Testing
   :dev {:plugins [[lein-inject-figwheel "0.1.0-SNAPSHOT"]]
         :cljsbuild {:builds
                     {:default
                      {:figwheel true
                       :compiler
                       {:asset-path "out"
                        :source-map true
                        :optimizations :none
                        :main {{name}}.ui}}}}
         :appengine {:inject true}}
   ;; DevServer, Deploy
   :war {:plugins [[lein-cljsbuild "1.1.2"]]
         :prep-tasks [["cljsbuild" "once"]]
         :cljsbuild {:builds
                     {:default
                      {:compiler
                       {:source-map "target/cljs/public/main.js.map"
                        :optimizations :advanced
                        :pseudo-names true
                        :verbose true}}}}
         :appengine {:enable-jar-classes false
                     :version "1"}}})
