(ns {{name}}.ui
    (:require-macros [cljs.core.async.macros :refer [go]])
    (:require [cljs.core.async :refer [<!]]
              [om.core :as om]
              [om.dom :as dom]
              [netkit.http :as http]
              [cljsjs.tether]
              [cljsjs.bootstrap]
              [appengine.datastore.query :as query]
              [uikit.app :as app]))

(def message
  (str "Simple can be harder than complex: "
       "You have to work hard to get your thinking clean to make it simple. "
       "But it’s worth it in the end because once you get there, "
       "you can move mountains."))

(def imagine "Everything you can imagine is real. -Pablo Picasso")

(def words-of-inspiration
  [imagine
   "The best way to predict the future is to invent it. -Alan Kay"
   "A point of view is worth 80 IQ points. -Alan Kay"
   "Lisp isn't a language, it's a building material. -Alan Kay"
   "Simple things should be simple, complex things should be possible. -Alan Kay"
   "Measuring programming progress by lines of code is like measuring aircraft building progress by weight. -Bill Gates"
   "Controlling complexity is the essence of computer programming. -Brian Kernighan"
   "The unavoidable price of reliability is simplicity. -C.A.R. Hoare"
   "You're bound to be unhappy if you optimize everything. -Donald Knuth"
   "Simplicity is prerequisite for reliability. -Edsger W. Dijkstra"
   "Deleted code is debugged code. -Jeff Sickel"
   "The key to performance is elegance, not battalions of special cases. -Jon Bentley and Doug McIlroy"
   "First, solve the problem. Then, write the code. -John Johnson"
   "Simplicity is the ultimate sophistication. -Leonardo da Vinci"
   "Programming is not about typing... it's about thinking. -Rich Hickey"
   "Design is about pulling things apart. -Rich Hickey"
   "Programmers know the benefits of everything and the tradeoffs of nothing. -Rich Hickey"
   "Code never lies, comments sometimes do. -Ron Jeffries"
   "The true delight is in the finding out rather than in the knowing.  -Isaac Asimov"])

(defn format-error [resp]
  (str (:status resp) " " (:status-message resp)))

(defn handle-error [resp]
  (->> resp
       (format-error)
       (swap! app/app-data assoc :error)))

(defn handle-click [e]
  (go (app/put! (with-meta {:message (rand-nth words-of-inspiration)}
                  {:key {:kind "Message"}}))
      (-> (<! (http/request "/error"))
          (handle-error))))

(defn main [{:keys [error datom]} owner]
  (reify
    om/IRender
    (render [this]
      (if error
        (dom/div #js {:className "alert alert-danger" :role "alert"} error)
        (dom/div nil
                 (dom/nav #js {:className "navbar navbar-light bg-faded"}
                          (dom/button #js {:className "navbar-toggler hidden-sm-up"
                                           :type "button"
                                           :button "collapse"
                                           :data-toggle "collapse"
                                           :data-target "#exCollapsingNavbar2"} "\u2630")
                          (dom/div #js {:className "collapse navbar-toggleable-xs"
                                        :id "exCollapsingNavbar2"}
                                   (dom/a #js {:className "navbar-brand"
                                               :href "#"} "{{name}}")))
                 (dom/div #js {:className "container"}
                          (dom/div #js {:className "jumbotron"}
                                   (dom/h1 #js {:className "display-3"}
                                           (apply str "Hello " (shuffle (seq "World!"))))
                                   (dom/p #js {:className "lead"} message)
                                   (dom/hr #js {:className "m-y-2"})
                                   (for [message (app/fetch! datom (query/kind "Message"))]
                                     (dom/p nil message))
                                   (dom/p #js {:className "lead"}
                                          (dom/a #js {:className "btn btn-primary btn-lg"
                                                      :href "#"
                                                      :role "button"
                                                      :onClick handle-click}
                                                 "Learn more")))))))))

(app/render (. js/document (getElementById "app")) main)
