/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.reflect.Invokable;
import com.google.inject.Module;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.aws.domain.Region;
import org.jclouds.blobstore.BlobStoreFallbacks;
import org.jclouds.blobstore.binders.BindBlobToMultipartFormTest;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseETagHeader;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.http.functions.ReturnTrueIf2xx;
import org.jclouds.http.options.GetOptions;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.S3Fallbacks;
import org.jclouds.s3.config.S3RestClientModule;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketLogging;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.domain.Payer;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.fallbacks.FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists;
import org.jclouds.s3.functions.ParseObjectFromHeadersAndHttpContent;
import org.jclouds.s3.functions.ParseObjectMetadataFromHeaders;
import org.jclouds.s3.internal.BaseS3AsyncClientTest;
import org.jclouds.s3.options.CopyObjectOptions;
import org.jclouds.s3.options.ListBucketOptions;
import org.jclouds.s3.options.PutBucketOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.jclouds.s3.xml.AccessControlListHandler;
import org.jclouds.s3.xml.BucketLoggingHandler;
import org.jclouds.s3.xml.CopyObjectHandler;
import org.jclouds.s3.xml.ListAllMyBucketsHandler;
import org.jclouds.s3.xml.ListBucketHandler;
import org.jclouds.s3.xml.LocationConstraintHandler;
import org.jclouds.s3.xml.PayerHandler;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="S3AsyncClientTest")
public abstract class S3AsyncClientTest<T extends S3AsyncClient>
extends BaseS3AsyncClientTest<T> {
    protected String url = "s3.amazonaws.com";

    public void testAllRegions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"putBucketInRegion", (Class[])new Class[]{String.class, String.class, PutBucketOptions[].class});
        for (String region : Region.DEFAULT_S3) {
            this.processor.createRequest(method, (List)ImmutableList.of((Object)region, (Object)("bucket-" + region)));
        }
    }

    public void testGetBucketLocation() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"getBucketLocation", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://bucket." + this.url + "/?location HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        request = (GeneratedHttpRequest)this.filter.filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "GET https://bucket." + this.url + "/?location HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Authorization: AWS identity:2fFTeYJTDwiJmaAkKj732RjNbOg=\nDate: 2009-11-08T15:54:08.897Z\nHost: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, LocationConstraintHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetBucketPayer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"getBucketPayer", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://bucket." + this.url + "/?requestPayment HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, PayerHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testSetBucketPayerOwner() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"setBucketPayer", (Class[])new Class[]{String.class, Payer.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)Payer.BUCKET_OWNER));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://bucket." + this.url + "/?requestPayment HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, "<RequestPaymentConfiguration xmlns=\"http://" + this.url + "/doc/2006-03-01/\"><Payer>BucketOwner</Payer></RequestPaymentConfiguration>", "text/xml", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testSetBucketPayerRequester() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"setBucketPayer", (Class[])new Class[]{String.class, Payer.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)Payer.REQUESTER));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://bucket." + this.url + "/?requestPayment HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, "<RequestPaymentConfiguration xmlns=\"http://" + this.url + "/doc/2006-03-01/\"><Payer>Requester</Payer></RequestPaymentConfiguration>", "text/xml", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testListBucket() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"listBucket", (Class[])new Class[]{String.class, ListBucketOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://bucket." + this.url + "/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, ListBucketHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testBucketExists() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"bucketExists", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://bucket." + this.url + "/?max-keys=0 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.FalseOnContainerNotFound.class);
        this.checkFilters((HttpRequest)request);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testCopyObjectInvalidName() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"copyObject", (Class[])new Class[]{String.class, String.class, String.class, String.class, CopyObjectOptions[].class});
        this.processor.createRequest(method, (List)ImmutableList.of((Object)"sourceBucket", (Object)"sourceObject", (Object)"destinationBucket", (Object)"destinationObject"));
    }

    public void testCopyObject() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"copyObject", (Class[])new Class[]{String.class, String.class, String.class, String.class, CopyObjectOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"sourceBucket", (Object)"sourceObject", (Object)"destinationbucket", (Object)"destinationObject"));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://destinationbucket." + this.url + "/destinationObject HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: destinationbucket." + this.url + "\nx-amz-copy-source: /sourceBucket/sourceObject\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CopyObjectHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteBucketIfEmpty() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"deleteBucketIfEmpty", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket"));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://bucket." + this.url + "/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, S3Fallbacks.TrueOn404OrNotFoundFalseOnIllegalState.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteObject() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"deleteObject", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)"object"));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://bucket." + this.url + "/object HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetBucketACL() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"getBucketACL", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://bucket." + this.url + "/?acl HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, AccessControlListHandler.class);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.ThrowContainerNotFoundOn404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetObject() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"getObject", (Class[])new Class[]{String.class, String.class, GetOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)"object"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://bucket." + this.url + "/object HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseObjectFromHeadersAndHttpContent.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.NullOnKeyNotFound.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetObjectACL() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"getObjectACL", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)"object"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://bucket." + this.url + "/object?acl HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, AccessControlListHandler.class);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.ThrowKeyNotFoundOn404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testObjectExists() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"objectExists", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)"object"));
        this.assertRequestLineEquals((HttpRequest)request, "HEAD https://bucket." + this.url + "/object HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.FalseOnKeyNotFound.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testHeadObject() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"headObject", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)"object"));
        this.assertRequestLineEquals((HttpRequest)request, "HEAD https://bucket." + this.url + "/object HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseObjectMetadataFromHeaders.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.NullOnKeyNotFound.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListOwnedBuckets() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"listOwnedBuckets", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "GET https://" + this.url + "/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: " + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, ListAllMyBucketsHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testNewS3Object() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"newS3Object", (Class[])new Class[0]);
        Assert.assertEquals((Object)method.getReturnType().getRawType(), S3Object.class);
    }

    public void testPutBucketACL() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"putBucketACL", (Class[])new Class[]{String.class, AccessControlList.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)AccessControlList.fromCannedAccessPolicy((CannedAccessPolicy)CannedAccessPolicy.PRIVATE, (String)"1234")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://bucket." + this.url + "/?acl HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, "<AccessControlPolicy xmlns=\"http://" + this.url + "/doc/2006-03-01/\"><Owner><ID>1234</ID></Owner><AccessControlList><Grant><Grantee xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"CanonicalUser\"><ID>1234</ID></Grantee><Permission>FULL_CONTROL</Permission></Grant></AccessControlList></AccessControlPolicy>", "text/xml", false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testPutBucketDefault() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"putBucketInRegion", (Class[])new Class[]{String.class, String.class, PutBucketOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "bucket"}));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://bucket." + this.url + "/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testPutObject() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"putObject", (Class[])new Class[]{String.class, S3Object.class, PutObjectOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)this.blobToS3Object.apply(BindBlobToMultipartFormTest.TEST_BLOB)));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://bucket." + this.url + "/hello HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, "hello", "text/plain", false);
        this.assertResponseParserClassEquals(method, request, ParseETagHeader.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testPutObjectACL() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"putObjectACL", (Class[])new Class[]{String.class, String.class, AccessControlList.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)"key", (Object)AccessControlList.fromCannedAccessPolicy((CannedAccessPolicy)CannedAccessPolicy.PRIVATE, (String)"1234")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://bucket." + this.url + "/key?acl HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, "<AccessControlPolicy xmlns=\"http://" + this.url + "/doc/2006-03-01/\"><Owner><ID>1234</ID></Owner><AccessControlList><Grant><Grantee xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"CanonicalUser\"><ID>1234</ID></Grantee><Permission>FULL_CONTROL</Permission></Grant></AccessControlList></AccessControlPolicy>", "text/xml", false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetBucketLogging() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"getBucketLogging", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://bucket." + this.url + "/?logging HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, BucketLoggingHandler.class);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.ThrowContainerNotFoundOn404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDisableBucketLogging() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"disableBucketLogging", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket"));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://bucket." + this.url + "/?logging HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, "<BucketLoggingStatus xmlns=\"http://" + this.url + "/doc/2006-03-01/\"/>", "text/xml", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testEnableBucketLoggingOwner() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"enableBucketLogging", (Class[])new Class[]{String.class, BucketLogging.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"bucket", (Object)new BucketLogging("mylogs", "access_log-", (Iterable)ImmutableSet.of((Object)new AccessControlList.Grant((AccessControlList.Grantee)new AccessControlList.EmailAddressGrantee("adrian@jclouds.org"), "FULL_CONTROL")))));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://bucket." + this.url + "/?logging HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: bucket." + this.url + "\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/bucket_logging.xml")), "text/xml", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    protected Module createModule() {
        return new TestS3RestClientModule();
    }

    @ConfiguresRestClient
    private static final class TestS3RestClientModule
    extends S3RestClientModule<S3Client, S3AsyncClient> {
        private TestS3RestClientModule() {
        }

        protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
            return "2009-11-08T15:54:08.897Z";
        }
    }
}

