/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.internal.BaseS3ClientExpectTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="S3ClientExpectTest")
public class S3ClientExpectTest
extends BaseS3ClientExpectTest {
    @Test
    public void testBucketExistsReturnsTrueOn200AndFalseOn404() {
        HttpRequest bucketFooExists = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("https://s3.amazonaws.com/foo?max-keys=0")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Date", (Object)"2009-11-08T15:54:08.897Z").put((Object)"Authorization", (Object)"AWS identity:p32RsBr2inawMBeCkkiA228BT2w=").build())).build();
        S3Client clientWhenBucketExists = (S3Client)this.requestSendsResponse(bucketFooExists, HttpResponse.builder().statusCode(200).build());
        assert (clientWhenBucketExists.bucketExists("foo"));
        S3Client clientWhenBucketDoesntExist = (S3Client)this.requestSendsResponse(bucketFooExists, HttpResponse.builder().statusCode(404).build());
        assert (!clientWhenBucketDoesntExist.bucketExists("foo"));
    }
}

