/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.options.GetOptions;
import org.jclouds.rest.RestContext;
import org.jclouds.s3.S3ApiMetadata;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.options.CopyObjectOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration", "live"})
public class S3ClientLiveTest
extends BaseBlobStoreIntegrationTest {
    String sourceKey = "apples";
    String destinationKey = "pears";

    public S3ClientLiveTest() {
        this.provider = "s3";
    }

    public S3Client getApi() {
        return (S3Client)((RestContext)((BlobStoreContext)this.view).unwrap(S3ApiMetadata.CONTEXT_TOKEN)).getApi();
    }

    @Test(groups={"integration", "live"})
    public void deleteContainerIfEmptyNotFound() throws Exception {
        assert (this.getApi().deleteBucketIfEmpty("dbienf"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void deleteContainerIfEmptyButHasContents() throws Exception {
        String containerName = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, "test");
            assert (!this.getApi().deleteBucketIfEmpty(containerName));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    protected URL getObjectURL(String containerName, String key) throws Exception {
        URL url = new URL(String.format("http://%s.%s/%s", containerName, URI.create(this.endpoint).getHost(), key));
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPutCannedAccessPolicyPublic() throws Exception {
        String containerName = this.getContainerName();
        try {
            String key = "hello";
            S3Object object = this.getApi().newS3Object();
            object.getMetadata().setKey(key);
            object.setPayload(TEST_STRING);
            this.getApi().putObject(containerName, object, new PutObjectOptions[]{PutObjectOptions.builder().acl(CannedAccessPolicy.PUBLIC_READ).build()});
            URL url = this.getObjectURL(containerName, key);
            Strings2.toStringAndClose((InputStream)url.openStream());
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyCannedAccessPolicyPublic() throws Exception {
        String containerName = this.getContainerName();
        String destinationContainer = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, this.sourceKey);
            this.validateContent(containerName, this.sourceKey);
            this.getApi().copyObject(containerName, this.sourceKey, destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.overrideAcl((CannedAccessPolicy)CannedAccessPolicy.PUBLIC_READ)});
            this.validateContent(destinationContainer, this.destinationKey);
            URL url = this.getObjectURL(destinationContainer, this.destinationKey);
            Strings2.toStringAndClose((InputStream)url.openStream());
        }
        finally {
            this.returnContainer(containerName);
            this.returnContainer(destinationContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPublicWriteOnObject() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String publicReadWriteObjectKey = "public-read-write-acl";
        final String containerName = this.getContainerName();
        try {
            S3Object object = this.getApi().newS3Object();
            object.getMetadata().setKey("public-read-write-acl");
            object.setPayload("");
            this.getApi().putObject(containerName, object, new PutObjectOptions[]{PutObjectOptions.builder().acl(CannedAccessPolicy.PUBLIC_READ_WRITE).build()});
            this.assertConsistencyAware(new Runnable(){

                @Override
                public void run() {
                    try {
                        AccessControlList acl = S3ClientLiveTest.this.getApi().getObjectACL(containerName, "public-read-write-acl");
                        Assert.assertEquals((int)acl.getGrants().size(), (int)3);
                        Assert.assertEquals((int)acl.getPermissions(AccessControlList.GroupGranteeURI.ALL_USERS).size(), (int)2);
                        Assert.assertNotNull((Object)acl.getOwner());
                        String ownerId = acl.getOwner().getId();
                        Assert.assertTrue((boolean)acl.hasPermission(ownerId, "FULL_CONTROL"));
                        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ"));
                        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "WRITE"));
                        Assert.assertFalse((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ_ACP"));
                        Assert.assertFalse((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "WRITE_ACP"));
                        Assert.assertFalse((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "FULL_CONTROL"));
                    }
                    catch (Exception e) {
                        Throwables.propagateIfPossible((Throwable)e);
                    }
                }
            });
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateObjectACL() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerName = this.getContainerName();
        try {
            String objectKey = "private-acl";
            this.addBlobToContainer(containerName, objectKey);
            AccessControlList acl = this.getApi().getObjectACL(containerName, objectKey);
            String ownerId = acl.getOwner().getId();
            Assert.assertEquals((int)acl.getGrants().size(), (int)1);
            Assert.assertTrue((boolean)acl.hasPermission(ownerId, "FULL_CONTROL"));
            this.addGrantsToACL(acl);
            Assert.assertEquals((int)acl.getGrants().size(), (int)4);
            Assert.assertTrue((boolean)this.getApi().putObjectACL(containerName, objectKey, acl));
            acl = this.getApi().getObjectACL(containerName, objectKey);
            this.checkGrants(acl);
            acl.revokeAllPermissions((AccessControlList.Grantee)new AccessControlList.CanonicalUserGrantee(ownerId));
            if (!ownerId.equals("1a405254c932b52e5b5caaa88186bc431a1bacb9ece631f835daddaf0c47677c")) {
                acl.revokeAllPermissions((AccessControlList.Grantee)new AccessControlList.CanonicalUserGrantee("1a405254c932b52e5b5caaa88186bc431a1bacb9ece631f835daddaf0c47677c"));
            }
            Assert.assertEquals((int)acl.getGrants().size(), (int)1);
            Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ"));
            Assert.assertTrue((boolean)this.getApi().putObjectACL(containerName, objectKey, acl));
            acl = this.getApi().getObjectACL(containerName, objectKey);
            Assert.assertEquals((int)acl.getGrants().size(), (int)1);
            Assert.assertEquals((int)acl.getPermissions(ownerId).size(), (int)0);
            Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ"), (String)acl.toString());
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrivateAclIsDefaultForObject() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String privateObjectKey = "private-acl";
        String containerName = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, privateObjectKey);
            AccessControlList acl = this.getApi().getObjectACL(containerName, privateObjectKey);
            Assert.assertEquals((int)acl.getGrants().size(), (int)1);
            Assert.assertNotNull((Object)acl.getOwner());
            String ownerId = acl.getOwner().getId();
            Assert.assertTrue((boolean)acl.hasPermission(ownerId, "FULL_CONTROL"));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPublicReadOnObject() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String publicReadObjectKey = "public-read-acl";
        final String containerName = this.getContainerName();
        try {
            S3Object object = this.getApi().newS3Object();
            object.getMetadata().setKey("public-read-acl");
            object.setPayload("");
            this.getApi().putObject(containerName, object, new PutObjectOptions[]{PutObjectOptions.builder().acl(CannedAccessPolicy.PUBLIC_READ).build()});
            this.assertConsistencyAware(new Runnable(){

                @Override
                public void run() {
                    try {
                        AccessControlList acl = S3ClientLiveTest.this.getApi().getObjectACL(containerName, "public-read-acl");
                        Assert.assertEquals((int)acl.getGrants().size(), (int)2);
                        Assert.assertEquals((int)acl.getPermissions(AccessControlList.GroupGranteeURI.ALL_USERS).size(), (int)1);
                        Assert.assertNotNull((Object)acl.getOwner());
                        String ownerId = acl.getOwner().getId();
                        Assert.assertTrue((boolean)acl.hasPermission(ownerId, "FULL_CONTROL"));
                        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ"));
                    }
                    catch (Exception e) {
                        Throwables.propagateIfPossible((Throwable)e);
                    }
                }
            });
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    protected String addBlobToContainer(String sourceContainer, String key) {
        S3Object sourceObject = this.getApi().newS3Object();
        sourceObject.getMetadata().setKey(key);
        sourceObject.getMetadata().getContentMetadata().setContentType("text/xml");
        sourceObject.setPayload(TEST_STRING);
        return this.getApi().putObject(sourceContainer, sourceObject, new PutObjectOptions[0]);
    }

    protected S3Object validateObject(String sourceContainer, String key) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        this.assertConsistencyAwareContainerSize(sourceContainer, 1);
        S3Object newObject = this.getApi().getObject(sourceContainer, key, new GetOptions[0]);
        assert (newObject != null);
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)newObject.getPayload().openStream()), (String)TEST_STRING);
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMetadataWithCacheControlAndContentDisposition() throws Exception {
        String key = "hello";
        S3Object object = this.getApi().newS3Object();
        object.getMetadata().setKey(key);
        object.setPayload(TEST_STRING);
        object.getMetadata().setCacheControl("no-cache");
        object.getMetadata().getContentMetadata().setContentDisposition("attachment; filename=hello.txt");
        String containerName = this.getContainerName();
        try {
            this.getApi().putObject(containerName, object, new PutObjectOptions[0]);
            S3Object newObject = this.validateObject(containerName, key);
            this.assertCacheControl(newObject, "no-cache");
            Assert.assertEquals((String)newObject.getMetadata().getContentMetadata().getContentDisposition(), (String)"attachment; filename=hello.txt");
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    protected void assertCacheControl(S3Object newObject, String string) {
        assert (newObject.getMetadata().getCacheControl().indexOf(string) != -1) : newObject.getMetadata().getCacheControl();
    }

    protected void assertContentEncoding(S3Object newObject, String string) {
        assert (newObject.getPayload().getContentMetadata().getContentEncoding().indexOf(string) != -1) : newObject.getPayload().getContentMetadata().getContentEncoding();
        assert (newObject.getMetadata().getContentMetadata().getContentEncoding().indexOf(string) != -1) : newObject.getMetadata().getContentMetadata().getContentEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testMetadataContentEncoding() throws Exception {
        String key = "hello";
        S3Object object = this.getApi().newS3Object();
        object.getMetadata().setKey(key);
        object.setPayload(TEST_STRING);
        object.getMetadata().getContentMetadata().setContentEncoding("x-compress");
        String containerName = this.getContainerName();
        try {
            this.getApi().putObject(containerName, object, new PutObjectOptions[0]);
            S3Object newObject = this.validateObject(containerName, key);
            this.assertContentEncoding(newObject, "x-compress");
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyObject() throws Exception {
        String containerName = this.getContainerName();
        String destinationContainer = this.getContainerName();
        try {
            this.addToContainerAndValidate(containerName, this.sourceKey);
            this.getApi().copyObject(containerName, this.sourceKey, destinationContainer, this.destinationKey, new CopyObjectOptions[0]);
            this.validateContent(destinationContainer, this.destinationKey);
        }
        finally {
            this.returnContainer(containerName);
            this.returnContainer(destinationContainer);
        }
    }

    protected String addToContainerAndValidate(String containerName, String sourceKey) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String etag = this.addBlobToContainer(containerName, sourceKey);
        this.validateContent(containerName, sourceKey);
        return etag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyIfModifiedSince() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerName = this.getContainerName();
        String destinationContainer = this.getContainerName();
        try {
            Date before = new Date();
            this.addToContainerAndValidate(containerName, this.sourceKey + "mod");
            Date after = new Date(System.currentTimeMillis() + 1000L);
            this.getApi().copyObject(containerName, this.sourceKey + "mod", destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceModifiedSince((Date)before)});
            this.validateContent(destinationContainer, this.destinationKey);
            try {
                this.getApi().copyObject(containerName, this.sourceKey + "mod", destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceModifiedSince((Date)after)});
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)412);
            }
        }
        finally {
            this.returnContainer(containerName);
            this.returnContainer(destinationContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyIfUnmodifiedSince() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerName = this.getContainerName();
        String destinationContainer = this.getContainerName();
        try {
            Date before = new Date();
            this.addToContainerAndValidate(containerName, this.sourceKey + "un");
            Date after = new Date(System.currentTimeMillis() + 1000L);
            this.getApi().copyObject(containerName, this.sourceKey + "un", destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceUnmodifiedSince((Date)after)});
            this.validateContent(destinationContainer, this.destinationKey);
            try {
                this.getApi().copyObject(containerName, this.sourceKey + "un", destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceModifiedSince((Date)before)});
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)412);
            }
        }
        finally {
            this.returnContainer(containerName);
            this.returnContainer(destinationContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyIfMatch() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerName = this.getContainerName();
        String destinationContainer = this.getContainerName();
        try {
            String goodETag = this.addToContainerAndValidate(containerName, this.sourceKey);
            this.getApi().copyObject(containerName, this.sourceKey, destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceETagMatches((String)goodETag)});
            this.validateContent(destinationContainer, this.destinationKey);
            try {
                this.getApi().copyObject(containerName, this.sourceKey, destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceETagMatches((String)"setsds")});
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)412);
            }
        }
        finally {
            this.returnContainer(containerName);
            this.returnContainer(destinationContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyIfNoneMatch() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        String containerName = this.getContainerName();
        String destinationContainer = this.getContainerName();
        try {
            String goodETag = this.addToContainerAndValidate(containerName, this.sourceKey);
            this.getApi().copyObject(containerName, this.sourceKey, destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceETagDoesntMatch((String)"asfasdf")});
            this.validateContent(destinationContainer, this.destinationKey);
            try {
                this.getApi().copyObject(containerName, this.sourceKey, destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceETagDoesntMatch((String)goodETag)});
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)412);
            }
        }
        finally {
            this.returnContainer(containerName);
            this.returnContainer(destinationContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyWithMetadata() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerName = this.getContainerName();
        String destinationContainer = this.getContainerName();
        try {
            this.addToContainerAndValidate(containerName, this.sourceKey);
            HashMap metadata = Maps.newHashMap();
            metadata.put("adrian", "cole");
            this.getApi().copyObject(containerName, this.sourceKey, destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.overrideMetadataWith((Map)metadata)});
            this.validateContent(destinationContainer, this.destinationKey);
            ObjectMetadata objectMeta = this.getApi().headObject(destinationContainer, this.destinationKey);
            Assert.assertEquals((Map)objectMeta.getUserMetadata(), (Map)metadata);
        }
        finally {
            this.returnContainer(containerName);
            this.returnContainer(destinationContainer);
        }
    }

    private void checkGrants(AccessControlList acl) {
        String ownerId = acl.getOwner().getId();
        Assert.assertEquals((int)acl.getGrants().size(), (int)4, (String)acl.toString());
        Assert.assertTrue((boolean)acl.hasPermission(ownerId, "FULL_CONTROL"), (String)acl.toString());
        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ"), (String)acl.toString());
        Assert.assertTrue((boolean)acl.hasPermission(ownerId, "WRITE_ACP"), (String)acl.toString());
        Assert.assertTrue((boolean)acl.hasPermission("1a405254c932b52e5b5caaa88186bc431a1bacb9ece631f835daddaf0c47677c", "READ_ACP"), (String)acl.toString());
    }

    private void addGrantsToACL(AccessControlList acl) {
        String ownerId = acl.getOwner().getId();
        acl.addPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ");
        acl.addPermission((AccessControlList.Grantee)new AccessControlList.EmailAddressGrantee("james@misterm.org"), "READ_ACP");
        acl.addPermission((AccessControlList.Grantee)new AccessControlList.CanonicalUserGrantee(ownerId), "WRITE_ACP");
    }
}

