/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore;

import com.google.common.base.Supplier;
import com.google.inject.Module;
import org.jclouds.blobstore.internal.BaseBlobSignerExpectTest;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.config.S3RestClientModule;
import org.testng.SkipException;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="S3BlobSignerExpectTest")
public class S3BlobSignerExpectTest
extends BaseBlobSignerExpectTest {
    public S3BlobSignerExpectTest() {
        this.provider = "s3";
    }

    protected HttpRequest getBlob() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://s3.amazonaws.com/container/name").addHeader("Date", new String[]{"Thu, 05 Jun 2008 16:38:19 GMT"})).addHeader("Authorization", new String[]{"AWS identity:0uvBv1wEskuhFHYJF/L6kEV9A7o="})).build();
    }

    @Test
    public void testSignGetBlobWithTime() {
        throw new SkipException("not yet implemented");
    }

    protected HttpRequest getBlobWithTime() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://s3.amazonaws.com/container/name").addHeader("Date", new String[]{"Thu, 05 Jun 2008 16:38:19 GMT"})).addHeader("Authorization", new String[]{"AWS identity:0uvBv1wEskuhFHYJF/L6kEV9A7o="})).build();
    }

    protected HttpRequest getBlobWithOptions() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://s3.amazonaws.com/container/name").addHeader("Range", new String[]{"bytes=0-1"})).addHeader("Date", new String[]{"Thu, 05 Jun 2008 16:38:19 GMT"})).addHeader("Authorization", new String[]{"AWS identity:0uvBv1wEskuhFHYJF/L6kEV9A7o="})).build();
    }

    protected HttpRequest putBlob() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://s3.amazonaws.com/container/name").addHeader("Expect", new String[]{"100-continue"})).addHeader("Date", new String[]{"Thu, 05 Jun 2008 16:38:19 GMT"})).addHeader("Authorization", new String[]{"AWS identity:j9Dy/lmmvlCKjA4lkqZenLxMkR4="})).build();
    }

    @Test
    public void testSignPutBlobWithTime() throws Exception {
        throw new SkipException("not yet implemented");
    }

    protected HttpRequest putBlobWithTime() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://s3.amazonaws.com/container/name").addHeader("Expect", new String[]{"100-continue"})).addHeader("Date", new String[]{"Thu, 05 Jun 2008 16:38:19 GMT"})).addHeader("Authorization", new String[]{"AWS identity:0uvBv1wEskuhFHYJF/L6kEV9A7o="})).build();
    }

    protected HttpRequest removeBlob() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://s3.amazonaws.com/container/name").addHeader("Date", new String[]{"Thu, 05 Jun 2008 16:38:19 GMT"})).addHeader("Authorization", new String[]{"AWS identity:4FnyjdX/ULdDMRbVlLNjZfEo9RQ="})).build();
    }

    protected Module createModule() {
        return new TestS3RestClientModule();
    }

    @ConfiguresRestClient
    private static final class TestS3RestClientModule
    extends S3RestClientModule<S3Client, S3AsyncClient> {
        private TestS3RestClientModule() {
        }

        protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
            return "Thu, 05 Jun 2008 16:38:19 GMT";
        }
    }
}

