/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import com.google.common.base.Function;
import javax.inject.Singleton;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.s3.options.ListBucketOptions;

@Singleton
public class BucketToContainerListOptions
implements Function<ListBucketOptions[], ListContainerOptions> {
    public ListContainerOptions apply(ListBucketOptions[] optionsList) {
        ListContainerOptions options = new ListContainerOptions();
        if (optionsList.length != 0) {
            if (optionsList[0].getDelimiter() == null) {
                options.recursive();
            } else if (!optionsList[0].getDelimiter().equals("/")) {
                throw new IllegalArgumentException("only '/' is allowed as a blobstore delimiter");
            }
            if (optionsList[0].getMarker() != null) {
                options.afterMarker(optionsList[0].getMarker());
            }
            if (optionsList[0].getMaxResults() != null) {
                options.maxResults(optionsList[0].getMaxResults().intValue());
            }
            if (optionsList[0].getPrefix() != null) {
                options.inDirectory(optionsList[0].getPrefix());
            }
        }
        return options;
    }
}

