/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.s3.blobstore.functions.LocationFromBucketName;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="LocationFromBucketNameTest")
public class LocationFromBucketNameTest {
    protected Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id("aws-ec2").description("aws-ec2").build();
    protected Location region = new LocationBuilder().scope(LocationScope.REGION).id("us-east-1").description("us-east-1").parent(this.provider).build();
    protected Location region2 = new LocationBuilder().scope(LocationScope.REGION).id("eu-west-1").description("eu-west-1").parent(this.provider).build();

    public void testOnlyLocationDoesntNeedMapping() {
        LocationFromBucketName fn = new LocationFromBucketName(Functions.forMap((Map)ImmutableMap.of()), Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.provider)));
        Assert.assertEquals((Object)fn.apply("mybucket"), (Object)this.provider);
    }

    public void testMapsToCorrectRegion() {
        LocationFromBucketName fn = new LocationFromBucketName(Functions.forMap((Map)ImmutableMap.of((Object)"mybucket", (Object)Optional.of((Object)"eu-west-1"))), Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region, (Object)this.region2)));
        Assert.assertEquals((Object)fn.apply("mybucket"), (Object)this.region2);
    }

    public void testNullOnUnmatchedRegion() {
        LocationFromBucketName fn = new LocationFromBucketName(Functions.forMap((Map)ImmutableMap.of((Object)"mybucket", (Object)Optional.of((Object)"eu-west-2"))), Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region, (Object)this.region2)));
        Assert.assertEquals((Object)fn.apply("mybucket"), null);
    }

    public void testNullOnAbsentData() {
        LocationFromBucketName fn = new LocationFromBucketName(Functions.forMap((Map)ImmutableMap.of((Object)"mybucket", (Object)Optional.absent())), Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region, (Object)this.region2)));
        Assert.assertEquals((Object)fn.apply("mybucket"), null);
    }
}

