/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.filters;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import org.jclouds.blobstore.binders.BindBlobToMultipartFormTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.internal.BaseS3AsyncClientTest;
import org.jclouds.s3.options.PutObjectOptions;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RequestAuthorizeSignatureTest")
public class RequestAuthorizeSignatureTest
extends BaseS3AsyncClientTest<S3AsyncClient> {
    String bucketName = "bucket";

    @DataProvider(parallel=true)
    public Object[][] dataProvider() throws NoSuchMethodException {
        return new Object[][]{{this.listOwnedBuckets()}, {this.putObject()}, {this.putBucketAcl()}};
    }

    @Test(threadPoolSize=3, dataProvider="dataProvider", timeOut=10000L)
    void testIdempotent(HttpRequest request) {
        request = this.filter.filter(request);
        String signature = request.getFirstHeaderOrNull("Authorization");
        String date = request.getFirstHeaderOrNull("Date");
        int iterations = 1;
        while (request.getFirstHeaderOrNull("Date").equals(date)) {
            date = request.getFirstHeaderOrNull("Date");
            if ((request = this.filter.filter(request)).getFirstHeaderOrNull("Date").equals(date)) {
                assert (signature.equals(request.getFirstHeaderOrNull("Authorization"))) : String.format("sig: %s != %s on attempt %s", signature, request.getFirstHeaderOrNull("Authorization"), iterations);
                continue;
            }
            ++iterations;
        }
        System.out.printf("%s: %d iterations before the timestamp updated %n", Thread.currentThread().getName(), iterations);
    }

    @Test
    void testAppendBucketNameHostHeader() throws SecurityException, NoSuchMethodException {
        GeneratedHttpRequest request = this.processor.createRequest(Reflection2.method(S3AsyncClient.class, (String)"getBucketLocation", (Class[])new Class[]{String.class}), (List)ImmutableList.of((Object)"bucket"));
        StringBuilder builder = new StringBuilder();
        this.filter.appendBucketName((HttpRequest)request, builder);
        Assert.assertEquals((String)builder.toString(), (String)"");
    }

    @Test
    void testAclQueryString() throws SecurityException, NoSuchMethodException {
        GeneratedHttpRequest request = this.putBucketAcl();
        StringBuilder builder = new StringBuilder();
        this.filter.appendUriPath((HttpRequest)request, builder);
        Assert.assertEquals((String)builder.toString(), (String)("/" + this.bucketName + "?acl"));
    }

    private GeneratedHttpRequest putBucketAcl() throws NoSuchMethodException {
        return this.processor.createRequest(Reflection2.method(S3AsyncClient.class, (String)"putBucketACL", (Class[])new Class[]{String.class, AccessControlList.class}), (List)ImmutableList.of((Object)"bucket", (Object)AccessControlList.fromCannedAccessPolicy((CannedAccessPolicy)CannedAccessPolicy.PRIVATE, (String)"1234")));
    }

    @Test
    void testAppendBucketNameHostHeaderService() throws SecurityException, NoSuchMethodException {
        GeneratedHttpRequest request = this.listOwnedBuckets();
        StringBuilder builder = new StringBuilder();
        this.filter.appendBucketName((HttpRequest)request, builder);
        Assert.assertEquals((String)builder.toString(), (String)"");
    }

    private GeneratedHttpRequest listOwnedBuckets() throws NoSuchMethodException {
        return this.processor.createRequest(Reflection2.method(S3AsyncClient.class, (String)"listOwnedBuckets", (Class[])new Class[0]), (List)ImmutableList.of());
    }

    @Test
    void testHeadersGoLowercase() throws SecurityException, NoSuchMethodException {
        HttpRequest request = this.putObject();
        TreeMultimap canonicalizedHeaders = TreeMultimap.create();
        this.filter.appendHttpHeaders(request, (SortedSetMultimap)canonicalizedHeaders);
        StringBuilder builder = new StringBuilder();
        this.filter.appendAmzHeaders((SortedSetMultimap)canonicalizedHeaders, builder);
        Assert.assertEquals((String)builder.toString(), (String)"x-amz-meta-adrian:foo\n");
    }

    private HttpRequest putObject() throws NoSuchMethodException {
        S3Object object = this.blobToS3Object.apply(BindBlobToMultipartFormTest.TEST_BLOB);
        object.getMetadata().getUserMetadata().put("Adrian", "foo");
        return this.processor.createRequest(Reflection2.method(S3AsyncClient.class, (String)"putObject", (Class[])new Class[]{String.class, S3Object.class, PutObjectOptions[].class}), (List)ImmutableList.of((Object)"bucket", (Object)object));
    }

    @Test
    void testAppendBucketNameInURIPath() throws SecurityException, NoSuchMethodException {
        GeneratedHttpRequest request = this.processor.createRequest(Reflection2.method(S3AsyncClient.class, (String)"getBucketLocation", (Class[])new Class[]{String.class}), (List)ImmutableList.of((Object)this.bucketName));
        URI uri = request.getEndpoint();
        Assert.assertEquals((String)uri.getHost(), (String)"s3.amazonaws.com");
        Assert.assertEquals((String)uri.getPath(), (String)("/" + this.bucketName));
    }

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        overrides.setProperty("jclouds.session-interval", "1");
        return overrides;
    }
}

