/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.base.Optional;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import org.easymock.EasyMock;
import org.jclouds.s3.functions.GetRegionForBucket;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(testName="GetRegionForBucketTest")
public class GetRegionForBucketTest {
    @Test
    void test() throws Exception {
        LoadingCache bucketToRegionCache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        EasyMock.expect((Object)bucketToRegionCache.get((Object)"bucket")).andReturn((Object)Optional.of((Object)"us-east-1"));
        EasyMock.replay((Object[])new Object[]{bucketToRegionCache});
        GetRegionForBucket fn = new GetRegionForBucket(bucketToRegionCache);
        Assert.assertEquals((Object)fn.apply("bucket"), (Object)Optional.of((Object)"us-east-1"));
        EasyMock.verify((Object[])new Object[]{bucketToRegionCache});
    }

    @DataProvider(name="exceptions")
    public Object[][] createExceptions() {
        return new Object[][]{{new ExecutionException(){}}, {new UncheckedExecutionException(){}}, {new CacheLoader.InvalidCacheLoadException("foo")}};
    }

    @Test(dataProvider="exceptions")
    void testGracefulOnException(Exception exception) throws Exception {
        LoadingCache bucketToRegionCache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        EasyMock.expect((Object)bucketToRegionCache.get((Object)"bucket")).andThrow((Throwable)exception);
        EasyMock.replay((Object[])new Object[]{bucketToRegionCache});
        GetRegionForBucket fn = new GetRegionForBucket(bucketToRegionCache);
        Assert.assertEquals((Object)fn.apply("bucket"), (Object)Optional.absent());
        EasyMock.verify((Object[])new Object[]{bucketToRegionCache});
    }
}

