/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.handlers;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.internal.BaseS3ClientExpectTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="S3RedirectionRetryHandlerExpectTest")
public class S3RedirectionRetryHandlerExpectTest
extends BaseS3ClientExpectTest {
    public void testRedirectOnHeadBucketChangesRequestToGetBucket() {
        HttpRequest bucketFooExists = ((HttpRequest.Builder)HttpRequest.builder().method("HEAD").endpoint(URI.create("https://s3.amazonaws.com/foo?max-keys=0")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Date", (Object)"2009-11-08T15:54:08.897Z").put((Object)"Authorization", (Object)"AWS identity:p32RsBr2inawMBeCkkiA228BT2w=").build())).build();
        HttpResponse redirectResponse = HttpResponse.builder().statusCode(301).build();
        HttpRequest bucketFooExistsNowUsesGET = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("https://s3.amazonaws.com/foo?max-keys=0")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Date", (Object)"2009-11-08T15:54:08.897Z").put((Object)"Authorization", (Object)"AWS identity:p32RsBr2inawMBeCkkiA228BT2w=").build())).build();
        HttpResponse success = HttpResponse.builder().statusCode(200).build();
        S3Client clientWhenBucketExists = (S3Client)this.requestsSendResponses(bucketFooExists, redirectResponse, bucketFooExistsNowUsesGET, success);
        assert (clientWhenBucketExists.bucketExists("foo"));
    }
}

