/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.LocalAsyncBlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.functions.HttpGetOptionsListToGetOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.date.DateService;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.lifecycle.Closer;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.blobstore.functions.BlobToObjectMetadata;
import org.jclouds.s3.blobstore.functions.BucketToContainerListOptions;
import org.jclouds.s3.blobstore.functions.ObjectToBlob;
import org.jclouds.s3.blobstore.functions.ResourceToBucketList;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketLogging;
import org.jclouds.s3.domain.BucketMetadata;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.Payer;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.options.CopyObjectOptions;
import org.jclouds.s3.options.ListBucketOptions;
import org.jclouds.s3.options.PutBucketOptions;
import org.jclouds.s3.options.PutObjectOptions;

@Singleton
public class StubS3AsyncClient
implements S3AsyncClient {
    private final DateService dateService;
    private final HttpGetOptionsListToGetOptions httpGetOptionsConverter;
    private final AsyncBlobStore blobStore;
    private final S3Object.Factory objectProvider;
    private final Blob.Factory blobProvider;
    private final ObjectToBlob object2Blob;
    private final BlobToObject blob2Object;
    private final BlobToObjectMetadata blob2ObjectMetadata;
    private final BucketToContainerListOptions bucket2ContainerListOptions;
    private final ResourceToBucketList resource2BucketList;
    private final ConcurrentMap<String, ConcurrentMap<String, Blob>> containerToBlobs;
    private final ConcurrentMap<String, Location> containerToLocation;
    private final ListeningExecutorService userExecutor;
    private final Closer closer;
    public static final String TEST_ACL_ID = "1a405254c932b52e5b5caaa88186bc431a1bacb9ece631f835daddaf0c47677c";
    public static final String TEST_ACL_EMAIL = "james@misterm.org";
    private static Map<String, Object> keyToAcl = new ConcurrentHashMap<String, Object>();
    public static final String DEFAULT_OWNER_ID = "abc123";

    @Inject
    private StubS3AsyncClient(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, LocalAsyncBlobStore blobStore, ConcurrentMap<String, ConcurrentMap<String, Blob>> containerToBlobs, ConcurrentMap<String, Location> containerToLocation, DateService dateService, S3Object.Factory objectProvider, Blob.Factory blobProvider, HttpGetOptionsListToGetOptions httpGetOptionsConverter, ObjectToBlob object2Blob, BlobToObject blob2Object, BlobToObjectMetadata blob2ObjectMetadata, BucketToContainerListOptions bucket2ContainerListOptions, ResourceToBucketList resource2BucketList, Closer closer) {
        this.userExecutor = userExecutor;
        this.containerToBlobs = containerToBlobs;
        this.containerToLocation = containerToLocation;
        this.blobStore = blobStore;
        this.objectProvider = objectProvider;
        this.blobProvider = blobProvider;
        this.dateService = dateService;
        this.httpGetOptionsConverter = httpGetOptionsConverter;
        this.object2Blob = (ObjectToBlob)Preconditions.checkNotNull((Object)object2Blob, (Object)"object2Blob");
        this.blob2Object = (BlobToObject)Preconditions.checkNotNull((Object)blob2Object, (Object)"blob2Object");
        this.blob2ObjectMetadata = (BlobToObjectMetadata)Preconditions.checkNotNull((Object)blob2ObjectMetadata, (Object)"blob2ObjectMetadata");
        this.bucket2ContainerListOptions = (BucketToContainerListOptions)Preconditions.checkNotNull((Object)bucket2ContainerListOptions, (Object)"bucket2ContainerListOptions");
        this.resource2BucketList = (ResourceToBucketList)Preconditions.checkNotNull((Object)resource2BucketList, (Object)"resource2BucketList");
        this.closer = (Closer)Preconditions.checkNotNull((Object)closer, (Object)"closer");
    }

    public ListenableFuture<Boolean> putBucketInRegion(@Nullable String region, String name, PutBucketOptions ... optionsList) {
        region = region == null ? "us-standard" : region;
        PutBucketOptions options = optionsList.length == 0 ? new PutBucketOptions() : optionsList[0];
        keyToAcl.put(name, options.getAcl());
        return this.blobStore.createContainerInLocation(new LocationBuilder().scope(LocationScope.REGION).id(region).description(region).build(), name);
    }

    public ListenableFuture<ListBucketResponse> listBucket(String name, ListBucketOptions ... optionsList) {
        ListContainerOptions options = this.bucket2ContainerListOptions.apply(optionsList);
        return Futures.transform((ListenableFuture)this.blobStore.list(name, options), (Function)this.resource2BucketList, (Executor)this.userExecutor);
    }

    public ListenableFuture<ObjectMetadata> copyObject(String sourceBucket, String sourceObject, String destinationBucket, String destinationObject, CopyObjectOptions ... nullableOptions) {
        CopyObjectOptions options = nullableOptions.length == 0 ? new CopyObjectOptions() : nullableOptions[0];
        ConcurrentMap source = (ConcurrentMap)this.containerToBlobs.get(sourceBucket);
        ConcurrentMap dest = (ConcurrentMap)this.containerToBlobs.get(destinationBucket);
        if (source.containsKey(sourceObject)) {
            Date unmodifiedSince;
            Date modifiedSince;
            Blob object = (Blob)source.get(sourceObject);
            if (options.getIfMatch() != null && !object.getMetadata().getETag().equals(options.getIfMatch())) {
                return Futures.immediateFailedFuture((Throwable)LocalAsyncBlobStore.returnResponseException((int)412));
            }
            if (options.getIfNoneMatch() != null && object.getMetadata().getETag().equals(options.getIfNoneMatch())) {
                return Futures.immediateFailedFuture((Throwable)LocalAsyncBlobStore.returnResponseException((int)412));
            }
            if (options.getIfModifiedSince() != null && (modifiedSince = this.dateService.rfc822DateParse(options.getIfModifiedSince())).after(object.getMetadata().getLastModified())) {
                return Futures.immediateFailedFuture((Throwable)LocalAsyncBlobStore.returnResponseException((int)412));
            }
            if (options.getIfUnmodifiedSince() != null && (unmodifiedSince = this.dateService.rfc822DateParse(options.getIfUnmodifiedSince())).before(object.getMetadata().getLastModified())) {
                return Futures.immediateFailedFuture((Throwable)LocalAsyncBlobStore.returnResponseException((int)412));
            }
            Blob sourceS3 = (Blob)source.get(sourceObject);
            MutableBlobMetadata newMd = BlobStoreUtils.copy((MutableBlobMetadata)sourceS3.getMetadata(), (String)destinationObject);
            if (options.getAcl() != null) {
                keyToAcl.put(destinationBucket + "/" + destinationObject, options.getAcl());
            }
            newMd.setLastModified(new Date());
            Blob newBlob = this.blobProvider.create(newMd);
            newBlob.setPayload(sourceS3.getPayload());
            dest.put(destinationObject, newBlob);
            return Futures.immediateFuture((Object)this.blob2ObjectMetadata.apply((BlobMetadata)BlobStoreUtils.copy((MutableBlobMetadata)newMd)));
        }
        return Futures.immediateFailedFuture((Throwable)new KeyNotFoundException(sourceBucket, sourceObject, sourceBucket + "/" + sourceObject));
    }

    public ListenableFuture<String> putObject(String bucketName, S3Object object, PutObjectOptions ... nullableOptions) {
        PutObjectOptions options;
        PutObjectOptions putObjectOptions = options = nullableOptions.length == 0 ? PutObjectOptions.DEFAULTS : nullableOptions[0];
        if (options.getAcl() != null) {
            keyToAcl.put(bucketName + "/" + object.getMetadata().getKey(), options.getAcl());
        }
        return this.blobStore.putBlob(bucketName, this.object2Blob.apply(object));
    }

    protected AccessControlList getACLforS3Item(String bucketAndObjectKey) {
        AccessControlList acl = null;
        Object aclObj = keyToAcl.get(bucketAndObjectKey);
        if (aclObj instanceof AccessControlList) {
            acl = (AccessControlList)aclObj;
        } else if (aclObj instanceof CannedAccessPolicy) {
            acl = AccessControlList.fromCannedAccessPolicy((CannedAccessPolicy)((CannedAccessPolicy)aclObj), (String)DEFAULT_OWNER_ID);
        } else if (aclObj == null) {
            acl = AccessControlList.fromCannedAccessPolicy((CannedAccessPolicy)CannedAccessPolicy.PRIVATE, (String)DEFAULT_OWNER_ID);
        }
        return acl;
    }

    public ListenableFuture<AccessControlList> getBucketACL(String bucket) {
        return Futures.immediateFuture((Object)this.getACLforS3Item(bucket));
    }

    public ListenableFuture<AccessControlList> getObjectACL(String bucket, String objectKey) {
        return Futures.immediateFuture((Object)this.getACLforS3Item(bucket + "/" + objectKey));
    }

    protected AccessControlList sanitizeUploadedACL(AccessControlList acl) {
        for (AccessControlList.Grant grant : acl.getGrants()) {
            if (!(grant.getGrantee() instanceof AccessControlList.EmailAddressGrantee)) continue;
            AccessControlList.EmailAddressGrantee emailGrantee = (AccessControlList.EmailAddressGrantee)grant.getGrantee();
            String id = emailGrantee.getEmailAddress().equals(TEST_ACL_EMAIL) ? TEST_ACL_ID : acl.getOwner().getId();
            grant.setGrantee((AccessControlList.Grantee)new AccessControlList.CanonicalUserGrantee(id, acl.getOwner().getDisplayName()));
        }
        return acl;
    }

    public ListenableFuture<Boolean> putBucketACL(String bucket, AccessControlList acl) {
        keyToAcl.put(bucket, this.sanitizeUploadedACL(acl));
        return Futures.immediateFuture((Object)true);
    }

    public ListenableFuture<Boolean> putObjectACL(String bucket, String objectKey, AccessControlList acl) {
        keyToAcl.put(bucket + "/" + objectKey, this.sanitizeUploadedACL(acl));
        return Futures.immediateFuture((Object)true);
    }

    public ListenableFuture<Boolean> bucketExists(String bucketName) {
        return Futures.immediateFuture((Object)this.containerToBlobs.containsKey(bucketName));
    }

    public ListenableFuture<Boolean> deleteBucketIfEmpty(String bucketName) {
        Boolean returnVal = true;
        if (this.containerToBlobs.containsKey(bucketName)) {
            if (((ConcurrentMap)this.containerToBlobs.get(bucketName)).size() == 0) {
                this.containerToBlobs.remove(bucketName);
            } else {
                returnVal = false;
            }
        }
        return Futures.immediateFuture((Object)returnVal);
    }

    public ListenableFuture<Void> deleteObject(String bucketName, String key) {
        return this.blobStore.removeBlob(bucketName, key);
    }

    public ListenableFuture<S3Object> getObject(String bucketName, String key, org.jclouds.http.options.GetOptions ... options) {
        GetOptions getOptions = this.httpGetOptionsConverter.apply(options);
        return Futures.transform((ListenableFuture)this.blobStore.getBlob(bucketName, key, getOptions), (Function)this.blob2Object, (Executor)this.userExecutor);
    }

    public ListenableFuture<ObjectMetadata> headObject(String bucketName, String key) {
        return Futures.transform((ListenableFuture)this.blobStore.blobMetadata(bucketName, key), (Function)new Function<BlobMetadata, ObjectMetadata>(){

            public ObjectMetadata apply(BlobMetadata from) {
                return StubS3AsyncClient.this.blob2ObjectMetadata.apply(from);
            }
        }, (Executor)this.userExecutor);
    }

    public ListenableFuture<? extends Set<BucketMetadata>> listOwnedBuckets() {
        return Futures.immediateFuture((Object)Sets.newLinkedHashSet((Iterable)Iterables.transform(this.containerToBlobs.keySet(), (Function)new Function<String, BucketMetadata>(){

            public BucketMetadata apply(String name) {
                return new BucketMetadata(name, null, null);
            }
        })));
    }

    public S3Object newS3Object() {
        return this.objectProvider.create(null);
    }

    public ListenableFuture<String> getBucketLocation(String bucketName) {
        Location location = (Location)this.containerToLocation.get(bucketName);
        return Futures.immediateFuture((Object)location.getId());
    }

    public ListenableFuture<Payer> getBucketPayer(String bucketName) {
        return Futures.immediateFuture((Object)Payer.BUCKET_OWNER);
    }

    public ListenableFuture<Void> setBucketPayer(String bucketName, Payer payer) {
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<Void> disableBucketLogging(String bucketName) {
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<Void> enableBucketLogging(String bucketName, BucketLogging logging) {
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<BucketLogging> getBucketLogging(String bucketName) {
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<Boolean> objectExists(String bucketName, String key) {
        return Futures.immediateFuture((Object)((ConcurrentMap)this.containerToBlobs.get(bucketName)).containsKey(key));
    }

    public void close() throws IOException {
        this.closer.close();
    }
}

