/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.options;

import com.google.common.base.Optional;
import org.jclouds.blobstore.options.CreateDirectoryOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.s3.blobstore.options.S3PutOptions;

public class S3CreateDirectoryOptions
extends CreateDirectoryOptions {
    public static final S3CreateDirectoryOptions ENCRYPT = new S3CreateDirectoryOptions(true);
    public static final S3CreateDirectoryOptions NO_ENCRYPT = new S3CreateDirectoryOptions(false);
    private final boolean useServerSideEncryption;
    private final Optional<PutOptions> putOptions;

    private S3CreateDirectoryOptions(boolean encrypt) {
        this.useServerSideEncryption = encrypt;
        S3PutOptions.Builder builder = S3PutOptions.builder();
        if (this.useServerSideEncryption) {
            builder.serverSideEncryption();
        }
        this.putOptions = Optional.of((Object)((Object)builder.build()));
    }

    public boolean usesServerSideEncryption() {
        return this.useServerSideEncryption;
    }

    public Optional<PutOptions> toPutOptions() {
        return this.putOptions;
    }
}

