/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.http.options.BaseHttpRequestOptions;
import org.jclouds.s3.domain.CannedAccessPolicy;

public class PutObjectOptions
extends BaseHttpRequestOptions {
    public static final String DEFAULT_CRYPTO_ALGORITHM = "AES256";
    public static final CannedAccessPolicy DEFAULT_ACCESS_POLICY = CannedAccessPolicy.PRIVATE;
    public static final boolean DEFAULT_SERVER_SIDE_ENCRYPTION = false;
    public static final PutObjectOptions DEFAULTS = new PutObjectOptions(DEFAULT_ACCESS_POLICY, false);
    private String headerTag;
    protected final boolean useServerSideEncryption;
    protected final CannedAccessPolicy acl;

    protected PutObjectOptions(CannedAccessPolicy acl, boolean useServerSideEncryption) {
        this.acl = acl;
        this.useServerSideEncryption = useServerSideEncryption;
    }

    @Inject
    public void setHeaderTag(@Named(value="jclouds.aws.header.tag") String headerTag) {
        this.headerTag = headerTag;
    }

    public Multimap<String, String> buildRequestHeaders() {
        Preconditions.checkState((this.headerTag != null ? 1 : 0) != 0, (Object)"headerTag should have been injected!");
        ImmutableMultimap.Builder returnVal = ImmutableMultimap.builder();
        for (Map.Entry entry : this.headers.entries()) {
            returnVal.put((Object)((String)entry.getKey()).replace("amz", this.headerTag), entry.getValue());
        }
        return returnVal.build();
    }

    public CannedAccessPolicy getAcl() {
        return this.acl;
    }

    public boolean usesServerSideEncryption() {
        return this.useServerSideEncryption;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean useServerSideEncryption = false;
        private CannedAccessPolicy acl = DEFAULT_ACCESS_POLICY;

        protected Builder() {
        }

        public Builder serverSideEncryption() {
            this.useServerSideEncryption = true;
            return this;
        }

        public Builder acl(CannedAccessPolicy acl) {
            this.acl = acl;
            return this;
        }

        public PutObjectOptions build() {
            PutObjectOptions rv = new PutObjectOptions(this.acl, this.useServerSideEncryption);
            if (this.useServerSideEncryption) {
                rv.replaceHeader("x-amz-server-side-encryption", PutObjectOptions.DEFAULT_CRYPTO_ALGORITHM);
            }
            if (!this.acl.equals((Object)CannedAccessPolicy.PRIVATE)) {
                rv.replaceHeader("x-amz-acl", this.acl.toString());
            }
            return rv;
        }
    }
}

