/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Set;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketLogging;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class BucketLoggingHandler
extends ParseSax.HandlerWithResult<BucketLogging> {
    private Set<AccessControlList.Grant> targetGrants = Sets.newHashSet();
    private StringBuilder currentText = new StringBuilder();
    private String currentId;
    private String currentDisplayName;
    private String currentGranteeType;
    private String currentPermission;
    private AccessControlList.Grantee currentGrantee;
    private String targetBucket;
    private String targetPrefix;

    public BucketLogging getResult() {
        if (this.targetBucket == null) {
            return null;
        }
        return new BucketLogging(this.targetBucket, this.targetPrefix, this.targetGrants);
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (qName.equals("Grantee")) {
            this.currentGranteeType = attrs.getValue("xsi:type");
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("TargetBucket")) {
            this.targetBucket = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("TargetPrefix")) {
            this.targetPrefix = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Grantee")) {
            if ("AmazonCustomerByEmail".equals(this.currentGranteeType)) {
                this.currentGrantee = new AccessControlList.EmailAddressGrantee(this.currentId);
            } else if ("CanonicalUser".equals(this.currentGranteeType)) {
                this.currentGrantee = new AccessControlList.CanonicalUserGrantee(this.currentId, this.currentDisplayName);
            } else if ("Group".equals(this.currentGranteeType)) {
                this.currentGrantee = new AccessControlList.GroupGrantee(URI.create(this.currentId));
            }
        } else if (qName.equals("Grant")) {
            this.targetGrants.add(new AccessControlList.Grant(this.currentGrantee, this.currentPermission));
        } else if (qName.equals("ID") || qName.equals("EmailAddress") || qName.equals("URI")) {
            this.currentId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("DisplayName")) {
            this.currentDisplayName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Permission")) {
            this.currentPermission = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

