/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import java.util.Date;
import javax.inject.Inject;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.internal.CopyObjectResult;
import org.jclouds.util.SaxUtils;

public class CopyObjectHandler
extends ParseSax.HandlerWithResult<ObjectMetadata> {
    private CopyObjectResult metadata;
    private StringBuilder currentText = new StringBuilder();
    @Inject
    private DateService dateParser;
    private Date currentLastModified;
    private String currentETag;

    public ObjectMetadata getResult() {
        return this.metadata;
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("ETag")) {
            this.currentETag = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("LastModified")) {
            this.currentLastModified = this.dateParser.iso8601DateOrSecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("CopyObjectResult")) {
            this.metadata = new CopyObjectResult(this.currentLastModified, this.currentETag);
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

